function varargout = uic(varargin) % create multiple uicontrol objects -----------------------
  n = 1;  h = [];        % equivalant to uicontrol if all property names are lower case
  for k = 1:2:nargin     % scan for 1st property name with capitalized first character
    p = varargin{k}(1);  % # of objects to create = the length of the property value cell array
    if p == upper(p) n = length(varargin{k+1}); break; end;  % found one!
  end;
  for k = 1:n                                     % create n uicontrols
    a = {};                                       % a will be the uicontrol argument list
    for j = 1:2:nargin                            % loop thru each property value
      p = varargin{j};  v = varargin{j+1};  q = p(1);  % if the property name is capitalized
      if q == upper(q) v = v{k}; end;                  % choose the kth property value
      p2 = [lower(p) '  '];  p2 = p2(1:3);  p1 = p2(1);
      if p1~='s' & p1~='t' & ischar(v)  % if it's not a string, tag, or tooltip property,
        v = strrep(v,'"','''');         % change double quotes to single quotes
      end;                              % (not needed for newer Matlab versions)
      if strcmp(p2,'bac') | strcmp(p2,'for') v = plt('cTriple',v);  % alternate color spec
      elseif strcmp(p2,'pos') if all(v<3) a = [a {'units' 'norm'}]; end;
      end;
      a = [a {p v}];
    end;
    h = [h; uicontrol(a{:})];  % create the kth uicontrol and collect the handles
  end;
  if length(h) == nargout  varargout = num2cell(h,2);
  else                     varargout{1} = h;
  end;