function H = pltt(x,y,ID) % Add trace (x,y) with trace name ID to the plt object in the current figure.
                          % both x and ID are optional arguments
  both=1;  % indicate both x & y arguments are provided
  switch nargin
    case 0, disp('Usage: H = pltt(x,y,ID);'); return;
    case 1, both=0; y=x; ID='';
    case 2, if ischar(y) | (iscell(y) & ischar(y{1})) ID=y;  y=x;  both=0;
            else                                      ID='';
            end;
  end;

  if iscell(y)                     % add multiple traces with y = cell array
    if ~iscell(ID) ID = {ID}; end;  ki = length(ID);   ky = length(y);
    if both if ~iscell(x) x = {x}; end;  kx = length(x);
            for k = 1:ky  pltt(x{min(k,kx)},y{k},ID{min(k,ki)}); end;
    else    for k = 1:ky  pltt(y{k},ID{min(k,ki)}); end;
    end;
    return;
  end;

  if min(size(y)) > 1              % add multiple traces with y = matrix
    if ~iscell(ID) ID = {ID}; end;   ki = length(ID);   sy = size(y);  s1 = sy(1);  s2 = sy(2);
    if both  sx = size(x); 
             if min(sx)~=1 disp('pltt error: x must be a row or column vector'); return; end;
             rc = find(sy==max(sx));
             if isempty(rc) disp('pltt error: rows or columns of y must be the same size as x'); return; end;
             if rc==1 for k = 1:s2 pltt(x,y(:,k),ID{min(k,ki)}); end;  % plot columns of y
             else     for k = 1:s1 pltt(x,y(k,:),ID{min(k,ki)}); end;  % plot rows of y
             end;
    else     if s2<s1 for k = 1:s2 pltt(y(:,k),ID{min(k,ki)}); end;  % plot columns of y
             else     for k = 1:s1 pltt(y(k,:),ID{min(k,ki)}); end;  % plot rows of y
             end;
    end;
    return;
  end;

  pch = getappdata(gcf,'pch');  np = length(pch); % number of patches
  if ~np disp('Must call plt from command line or include the ''+'' pararmeter'); end;

  if nargin==1 & length(y)==1 & floor(y)==y & y<=-1 & y>=-np  % here to delete a trace
    x = -y;  px = pch(x);                % x is trace number to delete
    ux = get(px,'user');  tx = ux{3};
    set(ux{2},'x',NaN,'y',NaN);          % delete data
    set(px,'vis','on');                  % turn patch on
    set(tx,'vis','off');                 % turn traceID off
    mk = getappdata(tx,'mk');  if length(mk) set(mk,'vis','off'); end;  % turn off line type markers
    return;
  end;

  % here to add a trace
  f = find(strcmp(get(pch,'vis'),'on')); % f is list indices to the visible patches
  if ~length(f) disp('pltt: No slots are available. (You can use pltt to remove a trace and free up a slot.)'); return; end;

  if ~both if isreal(y)  x = 1:length(y);
           else          x = real(y);  y = imag(y);
           end;
  end;
  p = pch(f(1));  set(p,'vis','off');      % use the first available slot
  u = get(p,'user');
  ymult = getappdata(gcf,'xymult');        % get metric prefix factors
  x = x*ymult(1);  u1 = u{1};  y = y*ymult(u1+1);
  H = u{2};  set(H,'x',x,'y',y);  ud = 0;
  ax = get(H,'parent');
  xl = get(ax,'xlim');  xg = get(ax,'xscale');  xg = xg(3)=='g'; % xg true for logx
  yl = get(ax,'ylim');  yg = get(ax,'yscale');  yg = yg(3)=='g'; % yg true for logy
  x1 = min(x);  x2 = max(x);  dx = (x2-x1)/30;  x1 = x1-dx;  x2 = x2+dx;
  y1 = min(y);  y2 = max(y);  dy = (y2-y1)/30;  y1 = y1-dy;  y2 = y2+dy;
  if x1 < xl(1)  if ~xg | x1>=0 xl(1)=x1;  ud=1;  end;  end;
  if x2 > xl(2)                 xl(2)=x2;  ud=1;        end;
  if y1 < yl(1)  if ~yg | y1>=0 yl(1)=y1;  ud=1;  end;  end;
  if y2 > yl(2)                 yl(2)=y2;  ud=1;        end;
  if u1==1 % are we adding a trace to a plot with no no traces?
    if ~xg & (x2-x1) < diff(xl)/100 xl = [x1 x2];  ud=1;  end;  % yes 
    if ~yg & (y2-y1) < diff(yl)/100 yl = [y1 y2];  ud=1;  end;
  end;
  if ud cur(get(ax,'user'),'xylim',[xl yl]); end;
  u3 = u{3};  if length(ID) set(u3,'string',ID); end;  set(u3,'vis','on');
  mk = getappdata(u3,'mk');  if length(mk) set(mk,'vis','on'); end;  % turn on line type markers
% end function pltt
