% Although plt is usually used for data exploration it can also be used to create
% publication quality plots by using a suitable set of parameters. This can be
% simplified by calling this function which calls plt with these defaults:
%
% The 'COLORdef',0 parameter   -  to select a white plot background
% The 'TraceID','' parameter   -  to remove the TraceID box
% The 'NoCursor'   option      -  to remove the cursor objects
% The '-All'       option      -  to remove the menu box
%
% The demo programs pub0, pub1, pub2, and xChart demonstrate the use of pltpub
% and also shows that any of the pltpub defaults may be overridden.
%
% If the first pltpub argument is 'Cpick' then the ColorPick action is
% assigned to all plt lines, axes, and labels. This makes it easy to make
% final color adjustments before the screen capture. It also has the
% (usually desirable) side effect that all mouse driven zoom and pan
% operations are disabled. (Don't include this argument if you need
% those mouse driven operations.)
%
% Consider creating your own functions similar to this one with sets
% of plt defaults that you use frequently.

% Author:  Paul Mennen (paul@mennen.org)
%          Copyright (c) 2022, Paul Mennen

function out = pltpub(varargin) % function optimized creating plots for publication
  v = strcmpi(varargin{1},'cpick');  if v varargin(1) = []; end;
  s = dbstack;  [a,s] = fileparts(s(min(end,2)).name); % s = calling function
  out = pltinit('ColorDef',0,'TraceID','','Options','Menu-All Nocursor','FigName',s,varargin{:});
  if v a = getappdata(gcf,'axis');             % assign the ColorPick action to all plt
       h = get(a,{'xlabel' 'ylabel' 'title'}); % axes, text, labels, lines, & grids so that
       t = findobj(gcf,'type','text')';        % you can change the colors of these
       g = findobj(gcf,'user','grid');         % objects by clicking on them.
       set([h{:} a out' g' t],'ButtonDown','plt ColorPick;');
  end;