function matplt(f)
% Creates a figure for plotting variables contained in a .mat file.
% The figure created looks the same as the figure created for the workspace plotter.
% Refer to the workspace plotting help section as a guide to how to use the resulting figure.
%
% Examples: -------------------------------
% matplt('c:\mcode\plt\ini\myfile.mat')    Opens the specified file with full path information
% matplt('c:\mcode\plt\ini\myfile')        Same as above
% matplt                                   Presents a dialog box so you can choose a file
% matplt('myfile.mat')                     Searches the path for the specified file and opens it if it's found
%                                          If it's not found, it behaves as if matplt was called with no arguments
% matplt('myfile')                         Same as above
% matplt myfile                            Same as above (command form)

  n = nargin;
  if n  if isempty(strfind(f,'.'))  f = [f '.mat'];  end;
        if ~exist(f)  f = which(f);  if isempty(f) n=0; end; end;
  end;
  if ~n | ~exist(f)
    [f,p] = uigetfile(inifile('a'),'Select a mat file');  f = [p f];
    if isnumeric(f) | ~exist(f) disp('mat file not found'); return; end;
  end;
  setappdata(0,'wplt',load(f));
  plt;
 
