function funcStart(v,d) % start a function running and return to caller immediately

% calling sequence:
%   funcStart(@func,d); or funcStart({@func arg1 arg2 ... },d); ------------------------
%      If funcStart is nested less than d levels below the command prompt then funcstart
%      calls function @func (with arguments if supplied) and then returns to the calling
%      function immediately without waiting for @func to complete. If funcStart is called
%      from a more deply nested function, then @func is called but it doesn't return to
%      the calling function until @func is complete.
%   funcStart(@func); or funcStart({@func arg1 arg2 ... }); -----------------------------
%      When called without the 2nd argument, d defaults to 2. This means that after @func
%      is initiated, execution of the calling function will continue immediately only
%      if funcStart was called from the command prompt or from the top level of a script
%      or function. Otherwise @func is called but it doesn't return until @func is complete.
%
% Because @func is called as a timer function callback, two extra arguments are
% added at the beginning of the argument list. This means that arg1 will actually
% be the 3rd argument of @func and arg2 will be the 4th, etc.
% Note: if you don't care about the nesting depth you can use funcStart(v,inf)

  dd = 2;  if nargin>1 dd = d; end;         % if depth is not specified, assume 2.
  if exist('dd') & length(feval('dbstack'))<=dd & exist('timer')  % should we return immediately?
                                            % Yes. (only possible with modern Matlab versions)
    t = feval('timer'); t.StartDelay = .01; % create the timer (feval to avoid compiler warning)
    t.TimerFcn = v;  start(t);              % call @func after 10 milliseconds
  else                                      % No. Too deeply nested or timer function doesn't exist
                                            % Here to return to calling function after @func completes
    if ~iscell(v) v = {v}; end;             % if v is a function handle, make it a cell array
    w = {v{1} 0 struct('Type','TimerFcn')}; % mimic extra 2 arguments inserted by timer function
    if length(v)>1 w = [w v(2:end)]; end;   % append additional arguments if there are any
    feval(w{:});                            % call the function
  end;
