function b64decode(infile,outfile)
  % Decodes the file named infile that was encoded using base64 encoding and saves it in a file named
  % outfile. outfile may also contain just the extension of the output file. For example:
  % b64decode('c:\path1\abc.txt','.exe') creates the output file c:\path1\abc.exe
  % If the second argument is not provided, '.bin' is assumed

  f = fopen(infile,'r');           % open input file
  if f<0 disp(sprintf('can''t open file %s',infile)); return; end;
  c = fread(f);  fclose(f);        % read input file
  c = c((c~=13) & (c~=10));        % ignore carriage returns and line feeds
  pd = c(end-1:end);               % last two characters may be padding (ascii 61 or =)
  sz = length(c)-length(find(pd==61));  % sz = length of encoded input (not including padding characters)
  sz = floor(.75*sz);              % sz is length of decoded output (3 bytes out for every 4 bytes in)
  t = 0 + 'BCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  tr = zeros(1,122);                                     % initialize translation table. max(t) = 122
  tr(t) = 1:63;                                          % build translation table
  c = reshape(tr(c),4,[]);                               % each element of c is 6 bits and each
                                                         % column of c is 24 bits (3 bytes)
  c = c(1,:)*262144 + c(2,:)*4096 + c(3,:)*64 + c(4,:);  % Each element of c is now 24 bits
  z1 = floor(c/65536);  c = c - 65536*z1;                % z1 is first byte
  z2 = floor(c/256);                                     % z2 is second byte
  z3 = c - 256*z2;                                       % z3 is third byte
  z = [z1; z2; z3];  z = z(:);                           % combine 1st, 2nd, and 3rd bytes
  if nargin<2 outfile = '.bin'; end;
  if outfile(1) == '.'                        % replace the extension with the specified string
    d = [length(infile) strfind(infile,'.')-1];  outfile = [infile(1:d(end)) outfile];
  end;
  f = fopen(outfile,'w');  fwrite(f,z(1:sz));  fclose(f);  % write output file

