function h = arrange(m)  % arrange m objects mostly filling the figure.
                         % Returns a cell array of normalized positions
  if ischar(m) m = str2num(m); end;                % allow command form
  n = m+3;  nc = ceil(sqrt(n));  nr = ceil(n/nc);  % number of columns and rows
  [x,y] = meshgrid(0:nc-1,0:nr-1);                 % define a regular grid for the regions
  w = .96/nc - .04;   h = .96/nr - .04;            % width and heigth of each region
  x(1,2) = -9;  x(2,1) = -9;  x(2,2) = -9;         % mark regions to be merged
  x = (w+.04)*x(:)+.04;  y = (h+.04)*y(:)+.04;     % .04 is the space between regions
  z = 0*x;  h = [x y w+z h+z];                     % The first region will be the bigest
  h = h(find(h(:,1)>0),:);  h(1,:) = 2*h(1,:);     % merge first 4 regions into one
  h = fix(1e3*h([1 end-m+2:end],:))/1e3;           % use 1st row and last m-1 rows
  h(:,4) = h(:,4) + 123e-9;  % keep 3 digits, then mark position as coming from arrange
  h = num2cell(h,2);         % convert to cell array
