% weight.m --- (version 13Aug23) ------------------------------------------------------------
%
% Displays the frequency response for four filters used in sound level measurements.
% For details about using this application as well as some of the programming techniques used,
% click on the "Help" tag in the menu box that appears near the left edge of the figure.
% Then click on the "weight" link in the Signal processing applications section.

% ----- Author: ----- Paul Mennen
% ----- Email:  ----- paul@mennen.org

function weight()
  f = 1000*10.^(-2 : 1/43 : 1.32);  s = 2*pi*f*1j;  % f = x axis for plot;  s = jw
  r = 87;                                           % 1000 Hz reference frequence [ f(r) = 1000 ]
  Hd = s .* (s.^2 + 6532*s + 4.0975e7) ./ ((s + 1776.3) .* (s + 7288.5) .* ...
       (s.^2 + 21514*s + 3.8836e8));                     Md = abs(Hd)/abs(Hd(r));  % D weight
  Hc = s.^2 ./ ((s + 129.4).^2 .* (s + 76655).^2);       Mc = abs(Hc)/abs(Hc(r));  % C weight
  Hb = Hc .* s ./ (s + 995.9);                           Mb = abs(Hb)/abs(Hb(r));  % B weight
  Ha = Hc .* s.^2 ./ ((s + 676.7) .* (s + 4636));        Ma = abs(Ha)/abs(Ha(r));  % A weight
  Mag = [Ma; Mb; Mc; Md];  MdB = 20*log10(Mag);  Ph = angle([Ha; Hb; Hc; Hd])*180/pi;
  ctrace = [9000; 10001; 101; 10100];                        % colors for the A/B/C/D weighting traces
  lw     = {1 1 1 1 2 2 2 2 1 1 1 1};                        % thicker lines for the dB Magnitude traces
  lbly   = {'Magnitude' 'Magnitude (dB)' 'Phase (degrees)'}; % Y axis labels
  htxt = {'To view only the A weighting filter (for example), right click on'; ...
          '"Aweight" in the TraceID box near the lower left corner of the figure.'; .33-.26i};
  S.lh = pltinit(f,[Mag; MdB; Ph],'Pos',[0 0 850 700],'Ctrace',ctrace,'Options','Xlog -Y',...
    'SubPlot',[30 50 20],'SubTrace',[4 4 4],'Xlim',f([1 end]),'Ylim',[-.06 1.5],'FigBKc',121818,...
    'FigName','A B C D Weighting','TIDcback',@tidCB,'LabelX','Hz','LabelY',lbly,'HelpText',htxt,...
    'TRACEid',prin('{%cweight!row}',65:68),'LineWidth',lw,'HelpFile','*/apps/weight.htm');
  set(gca,'XTickLabel',{'10' '100' '1000' '10,000'});
  S.ax = getappdata(gcf,'axis'); set(gcf,'user',S);  % save for traceID callback
  cur(-2,'ylim',[-60 15]);                           % set y limits (dB Magnitude)
  cur(-3,'ylim',[-200 200]);                         % set y limits (Phase in degrees)
  b = {'buttond'};                                   % copy buttondown functions
  set(S.lh(5:12),b,repmat(get(S.lh(1:4),b),2,1));    % Three axes, each with 4 lines
  cur(-1,'moveCB',@curCB);                           % set cursor callback
  curCB;  plt('HelpText','on');                      % update cursor and enable help text

function curCB()    % cursor callback --------------------------
   S = get(gcf,'user');  plt('HelpText','off');
   [n h]  = cur(-1,'getActive');   [xy k] = cur(-1,'get');
   x = real(xy);  y = get(S.lh(min(4,n)+[4 8]),'y');  y = [y{1}(k) y{2}(k)];
   c = get(h,'color');   e = findobj(gcf,'style','edit');
   set(e([8 4]),'Backgr',c,{'string'},prin('%5w dB ~; %6w%c',y,176));
   for m  = 2:3                                       % fixup the cursor for upper two axes
     mkr = findobj(S.ax(m),'markersize',8);           % find the subplot's cursor
     set(mkr,'x',x,'y',y(m-1),'color',c,'vis','on');  % update cursor position and color
   end;
%end function curCB

function tidCB()    % traceID callback -------------------------
  S = get(gcf,'user');  plt('HelpText','off');  a = {'vis'};
  set(S.lh(5:12),a,repmat(get(S.lh(1:4),a),2,1));
% end function tidCB
