function erip(In1)
  eripVer = 'Ver 12Jul24';
  if nargin S = get(gcf,'user');  S.d.N = In1;  wfile(S.txt,S.d,0);  loadB;  return;  end;  % popup callback
  c = [1 1 1]/12; p = figpos([1790 92]);
  if length(getappdata(0,'pltSmall'))  p(3) = 1383; end; % simulate smaller screen
% Create coefficient figure --------------------------------------------------------------------------
  S.cfig = figure('name','Filter coefficients','Menu','none','numberT','off',...
                  'Color',c,'pos',p,'CloseReq','plt misc close;','ResizeFcn',@cfSize);
  axes('pos',[0 0 1 1],'Color',c,'Xcolor',c,'Ycolor',c);
  S.txZ = text(0,0,'','tag','2');  S.txP = text(0,0,'','tag','2'); % Numerator & Denominator Polynomial
  set([S.txZ S.txP],'units','pix',{'Position'},{[138 81]; [138 29]},'Color',[1 .4 0],'buttond',@coefSF);
  set([text(0,0,'   DC gain'); text(0,0,'Quantize b'); text(0,0,'Quantize a')],'Color',[.5 .5 1],...
    'units','pix',{'Position'},{[-4 15]; [7 61]; [7 38]},{'buttond'},{''; {@qTiz,0}; {@qTiz,1}});
  p = {[64 5 62 17]; [81 27 45 17]; [81 49 45 17]; [5 71 75 17]}; % DCgain, QuantizeB, QuantazeA, Sym
  [S.gn S.qa S.qb S.sy] = uic('Pos',p,'style','edit','string','1','user',1,'backGr',101,...
                              'Callback',{@dcgn; {@qTiz,1}; {@qTiz,0}; ''});
  set(S.sy,'string','Symmetric','style','Check');

  % Create pole/zero plot ------------------------------------------------------------------------------
  uc = exp((0:.01:1)*pi*1j);   % uc = half unit circle (101 points)
  mb = [-2 .007 .12 .06 .21];   % move menu box up (make room for Tol slider)
  sz = get(S.cfig,'pos');  w = sz(3);  w1 = max(w*.53,733);  w2 = max(w*(.4566+w/4e5),636);
  pzt = pltinit(uc(2),uc(2),uc,'ENAcur',[1 1 0],'pos',[w1+20 135 w2 -620],'MotionEdit',@editPZ,... % pole/zero plot
        'Markers','oxn','Styles','nn-','LabelX','real','LabelY','imag','FIGname','Pole/Zero plot',...
        'Options','-H-X-Y','TRACEid',['Zeros '; 'Poles ';'circle'],'TRACEc',[101; 10100; 505051],...
        'xy',mb,'Xstring','sprintf("  (%4.3f, %4.2f\\circ)",abs(@XY),angle(@XY)*180/pi)');
  set(gcf,'ResizeFcn',@PZequal); PZequal;       % set the figure resize function to maintain aspect ratio
  cur 0 Emode Both;                             % use persistent editing mode
  set(findobj(gcf,'style','push'),'vis','off'); % delta & peak/valley buttons not needed
  setappdata(gcf,'EditCur',getappdata(gcf,'EditCur')+2);  % make edit cursor larger
  P = [.007 .68 .09 .04]; d = [0 .1 0 0]; % new pole, new zero, delete p/z buttons (Right click delete = undo)
  uic('Pos',{P; P+d/2; P+d},'Str',{'new pole' 'new zero' 'delete p/z'},...
      'Callb',{@newPZ @newPZ @PZcurCB},'ButtonDown',{'' '' {@PZcurCB 0}});
  S.pa = [patch(0,0,'k'); patch(0,0,'k')];      % create Xaxis patch and unit circle patch
  set(S.pa,'FaceColor',[0 .15 .15],'EdgeColor',[0 .15 .15]);
  uistack(S.pa,'bottom');                       % move patches to bottom of viewing stack
  if getappdata(0,'Mver') < 7                   % here only for Matlab 6 (bug workarounds)
    ch = get(gca,'child');  set(gca,'child',ch([3:end 1 2])); % uistack bug
    set(S.pa,'ButtonDown','cur 0 axisCB;');     % bug with patch
  end;
  S.sl = plt('slider',[.005 .06 .13],[.025 0 .05],'Tolerance',@sliderCB,[4 .001],'%1.3f');
  cur(0,'moveCB',@PZcurCB);
  S.z = pzt(1);  S.p = pzt(2);  S.pfig = gcf;  g = S.pfig;  if ~isnumeric(g) g = get(g,'Number'); end;
  set(S.cfig,'tag',sprintf('%d',g));

  % Create main plot -------------------------------------------------------------------------------------
  x = [0 1];  tc = [10101 10100 10001 10000 100];  % trace colors: white, yellow, purple, red, green
  % trace 1: Specification (magnitude)
  % trace 2: Filter result (magnitude, linear)
  % trace 3: Filter result (magnitude, dB)
  % trace 4: Filter result (phase)
  % trace 5: Specification (weighting)
  S.line = pltinit(x,[x; x; -100*x; 360*x-180; [.5 200]],'pos',[5 135 w1 -620],'xy',[.12 .105 .84 .88],...
   'LabelX','Frequency','LabelY',{'    | b(z) / a(z) |' 'Phase' 'Weight' 'Magnitude (dB)'},...
   'SubPlot',[66 17 17],'FigBKc',808,'HelpFile','*/apps/erip/erip.htm','Options','-X-Y','TraceC',tc,...
   'Linewidth',{2.5 1 1.5 1 1},'addTag',{'defLim' @lim},'TraceID',{']spec' 'mag' 'mag dB'},'TIDcback',@tid,'Link',S.pfig);
   if getappdata(0,'Mver') >= 8.04    % Here for "Late" Matlab versions (R2014b or later)
    plt xright TGLgrid;               % despite right axis, solid grid lines looks ok here
  end;
  S.txt = inifile('erip.txt');        % config file full path
  set(S.line(1),'linestyle','--');    % make spec a dashed line
  set(S.line(2:4),'tag','NoEdit');    % data tag in menu box only shows filter spec
  setappdata(gcf,'DataEdit',0);       % make it easier to edit both x and y coordinates
  setappdata(gca,'eRes',[10 10]);     % edit resolution is 10 pixels in x and y directions
  S.cid = getappdata(gcf,'cid');  S.ax  = getappdata(gcf,'axis'); % get cursor IDs and axis handles
  set(S.line(5),'marker','o');  set(S.ax(2:3),'xcolor',[0 0 0]);  % don't need Xaxis tick lables
  noCare = line([0 9e9],1.08*[1 1],'color',[1 1 1]/5);            % don't care regions
  S.care = line(0,0,'color',[0 .5 0],'marker','s');               %    do care regions
  set([S.care noCare],'linewidth',4,'button',@careT);             % fat line for care/don't care regions
  lp = [6 3i]/100;  bg = 111111;  p = {[.68 0 .27 .08] [.48 0 .2 .05]};
  plt('box',p,bg);  % put grey boxes around the next 5 edit objects and 1 popup control
  p = {[.68 .016 .07 .023]; [.75 .016 .05 .023];  % positions: Sr, grid
       [.80 .016 .07 .023]; [.87 .016 .04 .023];  % positions: rad, nz
       [.91 .016 .04 .023]; [.48 .032 .20 .100]}; % positions: np, pop
  [S.sr S.grid S.rad S.nz S.np] = dealv( ...
  plt('edit',p(1:5),{1 400 1 6 11},{@srate @srate @runB @runB @runB},'incr',{0 100 0 1 1},...
      'backGr',bg,'label',{{'Fs' lp} {'Grid' lp} {'Radius' lp} {'Nz' [3 3i]/100} {'Pz' [3 3i]/100}}));
  S.pop  = plt('pop',p{6} ,{0},'erip(@IDX)','offset',0,'hide');     % filter spec selector popup
  l23 = get(S.ax(2:3),'Ylabel');  set([l23{:}],'units','norm','pos',[1.05 .5]); % move labels to right side
  text(.15, -.12,eripVer,'units','norm','color',[.8 .4 0],'fontsize',9);        % create erip version string
  p = [.01 .94 .065 .029];  d = [0 .018 0 0];                     % position 7 buttons near the left edge
  u = uic('Pos',{p+d; p-2*d; p-4*d; p-6*d; p-9*d; p-11*d; p-13*d},...
          'String',{'Run';'Save';'Remove';'Reload';'pzPlot';'CoefFig';'fvtool'},...
          'Callback',{@runB; @saveB; @loadB; @loadB; {@togV,S.pfig}; {@togV,S.cfig}; @fvt},...
          'Buttondown',{'' @saveB '' '' '' '' @fvt});  % right click save button to save/overwrite
  S.ex = exist('iirlpnorm') | exist('iirlpnormmex');
  ff = fopen(strrep(S.txt,'txt','ini'));  if ff>0  t = fgetl(ff);  fclose(ff); else t='0'; end;
  if ~ischar(t) t = '0'; end;   t = sscanf(t,'%f');   if isempty(t) t = 0; end;
  c = 303e7 + t;  d = floor(c/1e5);  S.ex2 = (c - 1e5*d) * d - polyval([floor(d/3367) 9 9 16*29*9133],461);
  if ~S.ex & exist('noCare') & ispc                 % skip this if compiled or for nonWindows OS
    fd = strrep(which('erip.m'),'erip.m','iir\');  S.loc = fd;
    f1 = [fd 'f1.exe'];  S.ex = -exist(f1);         % does f1.exe exist?
    if ~S.ex  b64 = [fd 'iir.b64'];                 % come here if not. get name of base64 encoded zip file
              if exist(b64) b64decode(b64,'.zip');  % decode it creating the zip file
                            zp = [fd 'iir.zip'];    % name of zip file
                            if exist('unzip')       % does the unzip function exist?
                              unzip(zp,fd);         % yes, unzip the iir.zip archive
                              S.ex = -exist(f1);    % does f1.exe exist now? (from zip file)
                              if S.ex delete(zp); delete(b64); end;  % don't need the zip and b64 files anymore
                            else disp('--- Very old Matlab versions don''t have the unzip command.');
                                 disp(sprintf('--- So you will need to unzip %s manually.',zp));
                                 disp('--- Then iir design capability will be enabled after you restart erip.m');
                            end;
              end;
    end;
  end;
  % S.ex =  1;  iirlpnorm exists (DSP system toolbox installed)
  % S.ex = -1;  DSP system toolbox is not installed, but helper program iir.exe exists
  % S.ex =  0;  limited to linear phase FIR designs
  S.hfig = gcf;  set(S.hfig,'user',S);  set([S.pfig S.cfig],'user',S.hfig);
  loadB;                          % load erip.txt setup file
  cur(S.cid(1),'moveCB',@curCB);  % set cursor callback for main plot
  cur(S.cid(3),'moveCB',@curCB);  % set cursor callback for weighting function plot
  sliderCB;                       % set tolerance patch on pole zero plot
% end function erip

function PZequal(arg1,arg2);  % maintain aspect ratio of pz plot (for perfect circle)
  u = findobj('type','line','color',[.5 .5 .51]);  ax = get(u(1),'parent');  % find unit circle and it's axis
  p = get(ax,'pos') .* get(get(ax,'parent'),'pos'); % get size of pole/zero plot (convert normalized to pixels)
  xl = [-1.1 1.1];  dy = p(4) * diff(xl) / (p(3) * 15);  yl = [-dy 14*dy];
  if yl(2) < 1.3  yl = [-.093 1.3];  dx = 0.5 * p(3) * diff(yl) / p(4);  xl = [-dx dx]; end;
  set(ax,'xlim',xl,'ylim',yl);  plt('grid',ax);

function tid                             % TraceID callback function
  l = getappdata(gcf,'Lhandles');
  if all(strcmp(get(l(1:3),'vis'),'on') == [1; 0; 0])  % is "spec" the only enabled trace?
        m = 'b';  n = 'u';  % yes, change to persistent edit mode (both, updown)
  else  m = 'o';  n = 'o';  % no,  turn persistent edit mode "off"
  end;
  cur(get(get(l(1),'parent'),'user'),'Emode',m); % editing mode for main plot
  cur(get(get(l(5),'parent'),'user'),'Emode',n); % editing mode for weighting plot
% end function tid

function careT(arg1,arg2)                            % toggle don't care region --------------------
  S = get(gcf,'user');  s = S.care;  x = get(s,'x'); % get don't care regions
  cp = get(gca,'current'); a = find(x>cp(1,1));      % find x values to the right mouse click
  if isempty(a) | a(1)<2 set(s,'vis','off'); pause(0.3); set(s,'vis','on'); return; end;
  a = a(1)-1;  xs = x;                               % save old values in case we need to revert
  if isnan(x(a)) if a==1 x(a)=0; else x(a) = x(a-1); end; else x(a) = NaN; end;
  set(s,'x',x);  n = isnan(x(1:2:end));  m = [n(2:end) 0];    % revert if there are successive don't care
  if n(1) | n(end) | any(n&m) pause(0.3); set(s,'x',xs); end; % regions or one at the beginning or end.
%end function care

function coefCB(j) % called when jth coefficient is modified (j is negated for denominator)
  S = get(gcf,'user'); if ~isstruct(S) S = get(S,'user'); end;
  b = get(S.z,'user');  a = get(S.p,'user'); % get existing coefficients
  if j>0 bw = get(S.txZ(1),'user');          % change the value that was edited
         b(j)  = plt('edit',S.txZ(j+1),'get','value')/bw;
         if get(S.sy,'val') nb = length(b);  b(nb-j+1) = b(j);  m = floor(nb/2);
                            for k=1:m b(nb-k+1) = b(k); end;  ptxt(S,b,a);
         end;
  else   bw = get(S.txP(1),'user');
         a(-j) = plt('edit',S.txP(-j+1),'get','value')/bw;
  end;
  frq(S,b,a); pz(S,b,a); % update frequency response and pz plots
% end function coefCB

function coefSF(arg1,arg2) % toggle scale factor base (2/10/none)
  S = get(get(gcf,'user'),'user');
  switch get(gcbo,'tag'), case '2',  set(gcbo,'tag','10');
                          case '10', set(gcbo,'tag','');
                          otherwise, set(gcbo,'tag','2');
  end;
  ptxt(S,get(S.z,'user'),get(S.p,'user'));   % update polynomial text display
% end function coefSF

function curCB() % plot cursor callback for main plot and weighting function
  if ~getappdata(gcf,'NewData') return; end; % skip if data not modified
  setappdata(gcf,'NewData',[]);    S = get(gcf,'user');  f   = sort(get(S.line(1),'x'));
  wtx = get(S.line(5),'x');        nw = length(wtx);     nf = length(f);
  e = get(S.care,'x');  ex = [e(1) e(2:2:end-1) e(end)]; % freq. vector from care regions
  if isequal(f,ex) & isequal(f,wtx) return; end;  % nothing to do if no frequency values changed
  n = nf - nw;                   % number of points added
  p = ones(1,abs(n));    wt = get(S.line(5),'y');
  if     n<0  k = find([f p-1] ~= wtx);  k = k(1);           % points removed
              for m = 1:-n wt(min(k,length(wt))) = []; end;
  elseif n>0  k = find(f ~= [wtx p-1]);  k = k(1);           % points added
              if k>nw k=k-1; end;  if k<nw e = wt(k+1:end); else e = []; end;
              wt = [wt(1:k) wt(k)*p e];
  end;
  set(S.line(1),'x',f);  set(S.line(5),'x',f,'y',wt);
  edg = [f;f];  edg = edg(:);  edg = edg(2:end-1)';
  if length(edg)==length(e) edg = edg + e .* isnan(e); end;  % keep don't care regions if # of points didn't change
  set(S.care,'x',edg,'y',1.08*ones(size(edg)));  % set care regions
%end function curCB

function cfSize(arg1,arg2)                   % call when coefficient figure is resized
  hfig = get(gcf,'user');  if isempty(hfig) | isstruct(hfig) return; end;
  S = get(hfig,'user');    if ~isstruct(S) return; end;
  if length(S.txZ)>1 delete(S.txZ(2:end)); S.txZ = S.txZ(1); end;
  if length(S.txP)>1 delete(S.txP(2:end)); S.txP = S.txP(1); end;
  set(hfig,'user',S);  ptxt(S,get(S.z,'user'),get(S.p,'user'));   % update polynomial text display

function dcgn(arg1,arg2)
  S = get(get(gcf,'user'),'user');  b = get(S.z,'user');  a = get(S.p,'user'); % get coefficients
  b = b * sscanf(get(S.gn,'string'),'%f')/get(S.gn,'user');                    % adjust gain
  frq(S,b,a); ptxt(S,b,a); % update frequency response and polynomial text display
%end function dcgn

function frq(S,b,a) % update frequency response plot
  l = S.line;  p = conj(get(l(2),'user')) ;            % p = points around the unit circle
  p = polyval(fliplr(b),p) ./ polyval(fliplr(a),p);    % evaluate polynomials around unit circle
  H = abs(p);                                          % same as: H = abs(freqz(pn,pd,2*pi*x));
  HdB = max(20 * log10(H),-400); PH = angle(p)*180/pi; % zero represented as -400dB
  x = get(l(2),'x');  xc = get(S.care,'x');  m = [];   % m will be indices in do care regions
  for k = 1:2:length(xc) m = [m find(x >= xc(k) & x < xc(k+1))];  end;
  set(l(2:4),{'y'},{H; HdB-max(HdB(m)); PH}); % update frequency response plot (mag, magDB, phase)
  set(S.gn,'user',H(1),'string',Pftoa('%7w',H(1)));
% end function frq

function c = getxy(h)   % get the x and y coordinates of object h
  c = complex(get(h,'x'),get(h,'y'));
function setxy(h,c)     % set the x and y coordinates of object h
  set(h,'x',real(c),'y',imag(c));

function loadB(arg1,arg2) % load button callback
  S = get(gcf,'user');
  if strcmp(get(gcbo,'str'),'Remove')
    d = S.d;                             % here for Remove button callback
    if length(d.a)>1  N = d.N;  d.N = 1;  d.f(N)   = [];  d.des(N) = [];  d.wt(N) = [];  d.tran(N) = [];
                      d.grd(N) = [];      d.rad(N) = [];  d.b(N)   = [];  d.a(N)  = [];  d.qba(N) = [];
                      d.name(N) = [];     S.d = d;        set(gcf,'user',S);             wfile(S.txt,d,1);
    end;
  end;
  fi = fopen(S.txt);
  if fi<0  disp('erip.txt not found. Using default values');
           N = 1;  k = 1;  p = [get(gcf,'pos') get(S.pfig,'pos') get(S.cfig,'pos')];
           d.name{1} = 'Default';  d.f{1} = [0 .15 .4 .5  1]/2;  d.des{1} = [1 .8 1 0 0];
           d.wt{1} = [1 1 1 10 10];  d.tran{1} = 3;  d.grd(1) = 400;  d.rad(1) = 1;
           d.b{1} = ones(1,7);  d.a{1} = [1 zeros(1,11)];  d.qba{1} = [.1; .1];  d.Fs = 1;
  else                                          % read the entire erip.txt file
    t = fgetl(fi);  N = sscanf(t(7:end),'%d');  % get Fnum (the active filter)
    t = fgetl(fi);  p = sscanf(t(7:end),'%d')'; % get window positions
    for k = 1:100 % no more than 100 filter specifications can be saved
      t = fgetl(fi);  if ~ischar(t) break; end;  d.name{k} = t(find(t~='*'));
      t = fgetl(fi);  d.Fs(k)   = sscanf(t(7:end),'%f')';  % sampling rate (Hz)
      t = fgetl(fi);  d.f{k}    = sscanf(t(7:end),'%f')';  % band edges
      t = fgetl(fi);  d.des{k}  = sscanf(t(7:end),'%f')';  % desired response (linear)
      t = fgetl(fi);  d.wt{k}   = sscanf(t(7:end),'%f')';  % weighting function
      t = fgetl(fi);  d.tran{k} = sscanf(t(7:end),'%d')';  % transition bands
      t = fgetl(fi);  d.grd(k)  = sscanf(t(7:end),'%d');   % grid density
      t = fgetl(fi);  d.rad(k)  = sscanf(t(7:end),'%f');   % radius for erip optimizer
      t = fgetl(fi);  d.b{k}    = sscanf(t(7:end),'%f')';  % numerator polynomial
      t = fgetl(fi);  d.a{k}    = sscanf(t(7:end),'%f')';  % denominator polynomial
      t = fgetl(fi);  d.qba{k}  = sscanf(t(7:end),'%f')';  % quantization values (num/dem)
    end;
    fclose(fi);
  end;
  f = d.f{N};  wt = d.wt{N};  tran = d.tran{N};  b = d.b{N};  a = d.a{N};
  careX = [f; f];  careX(2,tran(tran>0)) = NaN;  careX = careX(:);  careX = careX(2:end-1)';
  S.nGrid = d.grd(N);  d.N = N;  fig3 = [gcf S.pfig S.cfig];
  if length(p)==12 set(fig3,{'pos'},{p(1:4); p(5:8); p(9:12)});
  else p = get(fig3,'pos');  p = round([p{:}]);
  end;
  d.p = p;  S.d = d;   set(gcf,'name',['erip: ' d.name{N}],'user',S);
  np = length(a)-1;  if ~np & a(1)<0  np = -1;  a = -a; end; % -1 indicates symetric FIR
  plt('edit',[S.nz S.np S.rad],'val',{length(b)-1 np d.rad(N)});
  set(S.sr,'string',Pftoa('%7w',d.Fs(N)));
  set(S.line([1 5]),'x',f,{'y'},{d.des{N}; wt});
  set(S.care,'x',careX,'y',1.08*ones(size(careX)));
  set([S.qb S.qa],{'string'},prin('{%6w!col}',d.qba{N}));
  set(S.line(2),'x',d.Fs(N)/2,'y',0);  srate;  % adjust sample rate
  frq(S,b,a); ptxt(S,b,a); pz(S,b,a); % update freq response plot, polynomial text & pz plot
  qTiz(-1,0,0); qTiz(-1,0,1); lim;    % set coef. pseudo edit object quantization values; reset axis limits
  p = plt('pop',S.pop,'get','axis');  p = get(p,'pos');      % get popup position
  p(4) = min(.036*k,.97);                                    % adjust popup height
  plt('pop',S.pop,'pos',p,'choices',S.d.name,'index',S.d.N); % set popup choices and current index
  if fi<0 runB(0,0); end; % compute filter shape if erip.txt file was missing
%end function loadB

function lim(a,b)  % reset axis limits to defaults
  S = get(gcf,'user');   x = get(S.line(2),'x');  set(S.ax,'xlim',x([1 end]));
  wt = get(S.line(5),'y');  wt = [min(wt) max(wt)];  dy = max(diff(wt),.1);  % for weigthing curve limits
  set(S.ax([1 3 4]),{'ylim'},{[-.03 1.09];  wt + dy*[-.1 .1];  [-103 9]});
  plt('grid',S.ax(1));  plt('grid',S.ax(2));  plt('grid',S.ax(3));

function saveB(arg1,arg2)  % Save button callback
  S = get(gcf,'user');  d = S.d;  N = d.N;
  tran = get(S.care,'x');  tran = find(isnan(tran(1:2:end)));  % transition bands
  if isempty(tran) tran = 0; end;  % zero indicates there are no transition bands
  d.p       = round([get(gcf,'pos') get(S.pfig,'pos') get(S.cfig,'pos')]);
  L = get(gcf,'SelectionT');  L = L(1)~='a';  % L is true for Left click
  if L new = inputdlg('Enter a name for the new filter specification: ');
       if isempty(new) return; end;  % Return if cancel button pressed
       a = new{1};                   % get user input
       if isempty(a) a = d.name{N};  % Here if user entered a blank string
                     if a(max(1,length(a)-1)) == '-' a(end) = a(end)+1; else a = [a '-A']; end;
       end;
       c = plt('pop',S.pop,'get','cell');  p = c{1};  p = get(p,'pos');
       c = [c{2} {a}];  N = length(c);  d.N = N;  p(4) = min(.036*N,.97);  d.name{N} = a;
       plt('pop',S.pop,'choices',c,'pos',p,'index',N);
  else set(gco,'vis','off'); pause(.5); set(gco,'vis','on'); % flash save button to indicate overwrite
  end;
  d.f{N}    = get(S.line(1),'x');  d.des{N}  = get(S.line(1),'y');  d.wt{N}   = get(S.line(5),'y');
  d.rad(N)  = plt('edit',S.rad);   d.grd(N)  = S.nGrid;             d.tran{N} = tran;
  d.b{N}    = get(S.z,'user');  if plt('edit',S.np)<0 d.a{N} = -1; else d.a{N} =   get(S.p,'user'); end;
  d.Fs(N)   = str2double(get(S.sr,'string'));   d.qba{N}  = str2double(get([S.qb S.qa],'str'))';
  S.d = d;   set(gcf,'user',S);  wfile(S.txt,d,1);
%end function saveB

function wfile(fi,d,mat)
  fib = strrep(fi,'.txt','BAK.txt');
  if ispc dos(['copy /y "' fi '" "' fib '" > NUL']); else  copyfile(fi,fib);  end;  % rename existing file
  f = fopen(fi,'wt');  fprintf(f,'Fnum: %d\n',d.N);  fprintf(f,' Pos: %s\n',prin('3{4{%d }   }',d.p));
  if mat coef.d = 0;  coef = rmfield(coef,'d'); end;     % create empty structure for .mat file
  for k = 1:length(d.grd)                                % loop thru each filter spec defined
    t = d.name{k};
    if mat w = t+0;                                      % don't create .mat file if mat=0
           c = (w>47 & w<58) | (w>64 & w<91) | (w>96 & w<123);  % ascii characters allowed in field names
           w(~c) = 95;  if w(1)==95 | (w(1)>47 & w(1)<58)  w = [120 w]; end; % can't start with _ or a digit
           w = char(w);  coef = setfield(coef,w,'b',d.b{k});  coef = setfield(coef,w,'a',d.a{k});
    end;
    fprintf(f,'******%s********************************\n%s', t,...
       prin('  Fs: %g\n   f: {%g }\n des: {%g }\n  wt: {%g }\ntran: {%g }\ngrid: %d\n rad: %g\n   b: {%11V }\n   a: {%11V }\n Qba: %g %g\n',...
            d.Fs(k),d.f{k},d.des{k},d.wt{k},d.tran{k},d.grd(k),d.rad(k),d.b{k},d.a{k},d.qba{k}));
   end;
   fclose(f);
   if mat save(strrep(fi,'.txt','.mat'),'coef'); end;  % also .mat file in plt\ini folder

function ptxt(S,b,a) % update polynomial text display
  bs = get(S.txZ(1),'tag');   as = get(S.txP(1),'tag');   clr = [1 1 1; 1 1 0];
  switch bs,  case '2',  bb = 16; bm = 4;
              case '10', bb = 10; bm = 1;
              otherwise, bb = 0;  bt = '';  bw = 1;
  end;
  switch as,  case '2',  ab = 16; am = 4;
              case '10', ab = 10; am = 1;
              otherwise, ab = 0;  at = '';  aw = 1;
  end;
  if bb bv = floor(log(min(abs(b(find(b)))))/log(bb));
        bw = bb^-bv;                             % numerator scale factor
        bt = prin('%s^{%d} *',bs,bm*bv);
  end;
  if ab av = floor(log(min(abs(a(find(a)))))/log(ab));
        aw = ab^-av;                             % denominator scale factor
        at = prin('%s^{%d} *',as,am*av);
  end;
  ex = 0;  bn = length(b);  an = length(a);  pn = length(S.txP);  zn = length(S.txZ);
  set(S.txZ(1),'str',prin('b(z)^{%02d} = %s',bn-1,bt),'user',bw);
  set(S.txP(1),'str',prin('a(z)^{%02d} = %s',an-1,at),'user',aw);
  p = get(get(S.gn,'parent'),'pos');  p=p(3)-27;     % get width of coefficient window
  x0 = 188;  dx = 65;  x = x0;  y = 84;              % display numerator polynomial
  for k = 1:max(bn,zn-1)
    j = k+1;  x=x+dx;  if x>p y=y-17; x=x0+dx; end;  % if x is too big use the next row
    if k>bn set(S.txZ(j),'vis','off');
    else
      if j>zn  if ~ex ex=1; ga=gca; axes(get(S.txZ(1),'parent')); end;
               c = clr(1 + mod(floor((k-1)/5),2),:);
               S.txZ(j) = plt('edit',[x y],0,{@coefCB,j-1},'color',c);
      end;
      plt('edit',S.txZ(j),'val',b(k)*bw,'vis','on');
    end;
  end;  % end for k = 1:max(bn,zn-1)
  x = x0;  y = 30;
  for k = 1:max(an,pn-1)                             % display denominator polynomial
    j = k+1;  x=x+dx;  if x>p y=y-17; x=x0+dx; end;  % if x is too big use the next row
    if k>an set(S.txP(j),'vis','off');
    else
      if j>pn  if ~ex ex=1; ga=gca; axes(get(S.txP(1),'parent')); end;
               c = clr(1 + mod(floor((k-1)/5),2),:);
               S.txP(j) = plt('edit',[x y],0,{@coefCB,1-j},'color',c);
      end;
      plt('edit',S.txP(j),'val',a(k)*aw,'vis','on');
    end;
  end;  % end for k = 1:max(an,pn)
  if an<2 sh = 'off'; else sh = 'on'; end;     % don't show denominator polynomial for
  set(S.txP(1:2),'vis',sh);                    % FIR filters
  if ex set(S.hfig,'user',S);                  % if edit objects were created: save them,
        axes(ga); qTiz(-1,0,0); qTiz(-1,0,1);  % restore previous axis % set edit quantization
  end;
% end function ptxt

function pz(S,b,a) % update pz plot
  z = roots(b);  p = roots(a);
  k = find(imag(z)<-.001);  z(k) = [];  % don't show roots on lower half plane
  k = find(imag(p)<-.001);  p(k) = [];
  set(S.z,'x',real(z),'y',imag(z),'user',b); % save numerator polynomial (b)
  set(S.p,'x',real(p),'y',imag(p),'user',a); % save denominator polynomial(a)
% end function pz

function newPZ(a,b)                   % add a new pole or zero
  S = get(get(gcf,'user'),'user');
  plt xleft EDIT 5;                   % exit data editing mode
  t = get(gco,'string');              % get button string (pole or zero?)
  u = 1 + (t(5)=='p');                % u=1/2 for new zero/pole
  if u==1 r = S.z; else r = S.p; end;
  setxy(r,[0 getxy(r)]);              % insert new root (0,0) at the beginning of list
  cur(-1,'setActive',u,1);            % move the cursor to the new root
  plt xleft EDIT 1;                   % and put it back into edit mode
% end function newPZ

function editPZ(a)              % MotionEdit function
    hact = a{3};                % hact is the handle of the moving edit cursor
    h=get(hact,'user'); h=h{1}; % h is handle of the line being edited
    p = getxy(hact);            % position of edit cursor (diamond)
    q = getxy(h);               % position of poles or zeros being edited
    q(a{9}) = p; setxy(h,q);    % replace its value with the cursor position & update the pz plot
    cur(-1);                    % update FrqResp & Xstring (mag/angle)
% end function editPZ

function PZcurCB(a,b,c)  % pz plot cursor callback (also delete P/Z button)
  S = get(gcf,'user');  if ~isstruct(S) S = get(S,'user'); end;
  z = getxy(S.z); p = getxy(S.p); % get zeros & poles from plot
  al = cur(-1,'getActive');   u = get(gco,'user');
  switch nargin
  case 0, ytol = plt('slider',S.sl);        % here for pz plot cursor callback (snap to tolerance)
          az=find(abs(imag(z))<ytol); ap=find(abs(imag(p))<ytol); % any roots close to the x axis?
          z(az)=real(z(az));          p(ap)=real(p(ap));          % if so, snap to the x axis
          az = find(abs(1-abs(z))<ytol);                          % any zeros close to the unit circle?
          z(az) = exp(angle(z(az))*1j);                           % if so, snap to the unit circle
  case 2, [xy k] = cur(-1,'get');  % delete P/Z button left click - deletes the cursored root
          if     al==1 & length(z)>=k set(gco,'user',[u 1 z(k)]);  z(k) = [];
          elseif al==2 & length(p)>=k set(gco,'user',[u 0 p(k)]);  p(k) = [];
          end;
          plt xleft EDIT 5;                 % exit data editing mode
  case 3, if isempty(u) return; end;        % delete P/Z button right click - MULTI-LEVEL UNDELETE
          if u(end-1)  z = [z u(end)]; else p = [p u(end)]; end; % restore the last deleted root
          set(gco,'user',u(1:end-2));
  end;
  setxy(S.z,z); setxy(S.p,p);                      % in case anything changed
  if nargin==2 cur(-1,'updateN',1); end;
  b = real(poly([z conj(z(find(imag(z)>1e-5)))])); % append complex conjugates, convert to polynomial
  a = real(poly([p conj(p(find(imag(p)>1e-5)))])); % append complex conjugates, convert to polynomial
  gain = get(S.gn,'user'); sa=sum(a); sb=sum(b);
  if gain & sa & sb b=b*gain*sa/sb; end;           % if we can, adjust dc gain to match previous dc term
  set(S.z,'user',b); set(S.p,'user',a);            % save numerator & denominator polynomials (b,a)
  plt('edit',[S.nz S.np],'val',{length(b)-1 length(a)-1});
  frq(S,b,a);  ptxt(S,b,a);                        % update freq response plot & polynomial text
% end function PZcurCB

function qTiz(arg1,arg2,denom)    % Quantize the numerator or denominator polynomial
                                  % to set quantization value only, use arg1<0
  S = get(gcf,'user');
  if ishandle(S) S = get(S,'user'); end;     % in case the PZ plot is the current figure
  b = get(S.z,'user');  a = get(S.p,'user'); % get existing coefficients
  if denom  q = S.qa;  e = S.txP;  c = a;  else  q = S.qb;  e = S.txZ;  c = b;  end;
  q = sscanf(get(q,'string'),'%f');
  e = e(2:end);  plt('edit',e,'incr',q); % change the increment value for the whole polynomial
  if arg1<0 return; end;
  if q > 0 c = round(plt('edit',e)/q)*q;  plt('edit',e,'val',num2cell(c));  end;
  if denom a = c/get(S.txP(1),'user'); else b = c/get(S.txZ(1),'user'); end;
  frq(S,b,a); pz(S,b,a); % update frequency response and pz plots
% end function qTiz

function runB(arg1,arg2) % Callback for run button
  S = get(gcf,'user');  [Nz Np rad] = dealv(plt('edit',[S.nz S.np S.rad]));
  des = get(S.line(1),'y');  f = get(S.line(1),'x');  Fs = S.d.Fs(S.d.N);   fe = Fs/2;  f = f/fe;
  ed  = get(S.care,'x')/fe;  b   = isnan(ed);  if length(ed)<2 return; end;
  ed  = ed(not(b + [0 b(1:end-1)]));     % remove don't care regions
  if isempty(ed) ed = [0 fe]; end;
  b = ~diff(ed);  edges = ed(not([b 0] + [0 b]));       % concatinate adjacent do care regions
  wt = get(S.line(5),'y');  filname = S.d.name{S.d.N};
  di = strcmp(filname(1:3),'Dif') & Np<1;  % di true for differentiator filter designs
  hi = strcmp(filname(1:3),'Hil') & Np<1;  % hi true for Hilbert filter designs
  if ~S.ex | S.ex2 | Np==-1 | di | hi
    for k = 1:length(b)                        % here to design a linear phase FIR filter
      if b(k) j = k+1;  ed(j) = ed(j)*1.001;   % make edge frequencies increasing
              des = [des(1:k) des(k:end)];     % duplicate kth element
              wt  = [ wt(1:k)  wt(k:end)];
      end;
    end;
    if Np >= 0
      plt('edit',S.np,'val',-1);
      if S.ex2 & (ispc | S.ex>0)
        a = inputdlg(sprintf(...
            ['You must register erip to enable the design of IIR filters.\n' ...
             'Registration is FREE!\n' ...
             'Send an email to paul@mennnen.org with the subject line "erip registration".\n' ...
             'I will reply with a registration number which you should enter below:']));
        if length(a)  f = fopen(strrep(S.txt,'txt','ini'),'w');
                      fprintf(f,a{1});  fclose(f);  g = gcf;
                      m = msgbox('The registration number has been saved. Restart erip.');
                      p = get(m,'pos');  p(3) = 400;  set(m,'pos',p);
                      set(findobj(m,'type','text'),'fontsize',16);
                      close(g);   return;
        end;
      end;
    end;
    a = 1;  % use Parks McClellan linear phase FIR filter
    b = parks(Nz*(1-2*di)*(1-hi+hi*1i),ed,des,wt(1:2:end));
              % The parks() call replaces the following code ----------------
              %   if di      b = firpm(Nz,ed,des,w,'differentiator');
              %   elseif hi  b = firpm(Nz,ed,des,w,'Hilbert');
              %   else       b = firpm(Nz,ed,des,w);
              %   end; ------------------------------------------------------
  elseif S.ex<0 | getappdata(0,'Mver') < 7  % for Matlab version 6 -----------------
    if S.ex<0  save([S.loc 'iirParam'],'Nz','Np','edges','f','des','wt','rad','-v4');
               dos([S.loc 'iir']);  load([S.loc 'iirH']);
    else
      P = [2 128];  dens = 20;  Ho = .001;
      if ~Np            [b,err]      = firlpnormmex(Nz,edges,f,des,wt,P,dens,[],0);  a = 1;
      else
        if rad & rad<1  [b,a,h0,err] = iirlpnormcmex(Nz,Np,edges,f,des,wt,rad,P,dens,Ho,[],[]);
        else            [b,a,h0,err] = iirlpnormmex(Nz,Np,edges,f,des,wt,P,dens,Ho,[],[]);
        end;
      end;
    end;
    if Np
      ns = fix((max(Nz,Np) + 1) / 2);  % number of sections
      bs = tos(b,Nz,ns);  as = tos(a,Np,ns);   b = 1;  a = 1;
      for m=1:ns  b = conv(b,bs(m,:));  a = conv(a,as(m,:)); end;
      b = b.*h0;
      if length(b)>3  if ~b(end)  b(end)=[]; end; end; % remove trailing zero
      if length(a)>3  if ~a(end)  a(end)=[]; end; end; % remove trailing pole
      while length(b) & ~b(1)  b(1) = []; end;         % remove leading zeros
      while length(a) & ~a(1)  a(1) = []; end;         % remove leading poles
    end;
  else                  % Matlab version 7 or greater comes here
    try  if ~Np                 b = firlpnorm(Nz,f,edges,des,wt);  a = 1;
         elseif rad & rad<1 [b,a] = iirlpnormc(Nz,Np,f,edges,des,wt,rad);
         else               [b,a] = iirlpnorm(Nz,Np,f,edges,des,wt);
         end;
    catch ME, if strcmp(ME.identifier,'dsp:pinit:MexErr')
                   msg = 'iirlpnorm failed. Try increasing or decreasing the numerator order by one.';
              else msg = ME.message;
              end;
              msgbox(msg); return;
    end;
  end;
  if b(1)<0 b = -b; end;
  frq(S,b,a); ptxt(S,b,a); pz(S,b,a); % update freq response plot, polynomial text & pz plot
%end function runB

function b = tos(bs,Nz,ns)  % used only for Matlab 6
  b = [];  m = 0;           % convert to second order sections
  for k = 1:Nz/2  b = [b; 1 bs(m+1) bs(m+2)];   m=m+2;  end;
  if mod(Nz,2)    b = [b; 1 bs(m+1) 0];         m=m+2;  end;
  s = ns - m/2;   if s > 0  b = [b; repmat([0 0 1],s,1)];  end;
% end function tos

function sliderCB()                                  % tolerance slider callback
  S = get(gcf,'user');
  if ishandle(S) S = get(S,'user'); end;             % in case the PZ plot is the current figure
  v = plt('slider',S.sl);                            % get tolerance value from slider
  setxy(S.pa(1),[-1-v -1-v 1+v 1+v]+[-v v v -v]*1j); % set patch around x axis
  uc = exp((0:.02:1)*pi*1j);                         % half unit circle
  setxy(S.pa(2),[(1+v)*uc (1-v)*fliplr(uc)]);        % set patch around unit circle (outside/inside)
% end function sliderCB

function srate(arg1,arg2)  % sample rate parameter callback
  S   = get(gcf,'user');
  sr2 = str2double(get(S.sr,'string'))/2;  % half sample rate
  ng  = S.nGrid;  S.nGrid = min(1e6,max(16,round(str2double(get(S.grid,'string')))));
  x = get(S.line(2),'x');  sxe = sr2/x(end);  set(S.line([1 5]),'x',sxe*get(S.line(1),'x'));
  x = sr2 * (0 : 1/S.nGrid : 1);  set(S.line(2:4),'x',x);  set(S.care,'x',sxe*get(S.care,'x'));
  if ng ~= S.nGrid   set(S.grid,'string',int2str(S.nGrid));  set(gcf,'user',S);
                     set(S.line(2:4),'y',zeros(1,S.nGrid+1));
  end;
  cur(S.cid(1),'xlim',[0 sr2]);  set(S.line(2),'user',exp(pi*(x/x(end))*1i));
%end function srate

function togV(arg1,arg2,f) % toggle visibility of figure f
  if strcmp(get(f,'vis'),'on') set(f,'vis','off'); else set(f,'vis','on'); end;
% end function togV

function fvt(arg1,arg2);                             % fvtool button callback
  S = get(gcf,'user');  b = get(S.z,'user');  a = get(S.p,'user');  bn = length(b);  an = length(a);
  L = get(gcf,'SelectionT');  L = L(1)~='a';         % L is true for Left click
  if L & exist('L') & exist('fvtool')  fvtool(b,a);  % run fvtool with the current coefficients
  else                                               % here for fvtool right click action which creates
    if an==1 n = bn;  else n = 500; end;             % a step and impulse response plot without calling fvtool
    imp = filter(b,a,[1 zeros(1,n-1)]);
    p = getappdata(gcf,'Lhandles');  phx = get(p(4),'x');  phy = unwrap(get(p(4),'y')*pi/180);
    if n==500 ai = abs(imp);  mx = max(ai)*.002;  while ai(n) < mx  n=n-1; end;  imp = imp(1:n);  end;
    stp = cumsum(imp);  x = 0:n-1;  iYL = [min(imp) max(imp)];  sYL = [min(stp) max(stp)];
    sz = get(gcf,'pos') + [0 -90 20 0];  sz(3) = .82*sz(3);  p1 = [.005 .018 .033];  p2 = [.005 .084 .033];
    p = [0 .106 .055 .877 .93; -2 .007 .45 .05 .18; 216 .11 p1; 214 .133 p2; 215 .68 p1; 213 .703 p2; 204 .79 p2];
    pltinit(Pvbar(x,0,imp),Pvbar(x,0,stp),'SubPlot',[50 50],'linewidth',3,'Xlabel','Samples',...
       'Ylabel',{'Impulse response' 'Step response'},'Figname','Step & Impulse Respsonse',...
       'Xlim',[0 n],'pos',sz,'Options','-X-Y','xy',p);
    set(getappdata(gcf,'axis'),{'Ylim'},{iYL+[-1 1].*diff(iYL)/20; sYL+[-1 1].*diff(sYL)/20});
    sz = get(gcf,'pos');  pd = -phy/(2*pi)./phx;  phxx = (phx(2:end)+phx(1:(end-1)))/2;
    n = length(phx);  m = 2*n -1;
    if bn>1 N = 0:bn-1; gb = real(fft(N.*b,m)./fft(b,m));  gb = gb(1:n); else gb = 0; end;
    if an>1 N = 0:an-1; ga = real(fft(N.*a,m)./fft(a,m));  ga = ga(1:n); else ga = 0; end;
    gd = gb - ga;  pd = phx(2)*cumsum(gd)./phx([2:end end]);
    p = [0 .106 .055 .877 .93; -2 .007 .35 .05 .18;
         222 .11 p1; 220 .133 p2; 221 .68 p1; 219 .703 p2; 210 .79 p2; 204 .877 p2];
    pltinit(phx,[pd; gd; phy],'xy',p,...
        'SubPlot',[40 40 20],'pos',sz + [sz(3)+20 -8 0 0],'Figname','Phase and Group Delay',...
        'Options','-X-Y','Xlabel','Frequency','Ylabel',{'Phase delay' 'Group delay' 'Phase'});
    pYL = [min(pd) max(pd)];  gYL = [min(gd) max(gd)];  uYL = [min(phy) max(phy)];
    set(getappdata(gcf,'axis'),{'Ylim'},...
    {pYL+[-1 1].*diff(pYL)/20; gYL+[-1 1].*diff(gYL)/20; uYL+[-1 1].*diff(uYL)/20});
  end;
% end function fvt
