% wfalltst.m ------------------------------------------------------------------
%
% This program demonstrates the use of "pltwater", a general
% purpose 3D plotting utility.
%
% A surface consisting of a sequence of sync functions is
% created (in z, a 800 x 200 array).
%
% We could have called pltwater with just a single argument (z)
% containing the data, but in this example we have included
% many parameters to tailor the display. These include the
% nT,skip,x,y,HelpTxt parameters which are described in the
% pltwater section of the help file as well as in the comments
% in pltwater.m. The remaining parameters included in the
% pltwater command in this example (HelpText,TraceC,CursorC,
% Title,^Fontsize,LableY,xy) are not unique to pltwater, so they
% are passed directly to plt and are described in the main plt
% programming section of the help file.

% ----- Author: ----- Paul Mennen
% ----- Email:  ----- paul@mennen.org

htxt = { ...  % help text ----------------------------------------
  '\bullet Demonstrates the use of the pltwater function.' .03+.98i 'fontsize' 16 'color' [1 1 0] 2i ...
  '\bullet To advance one frame, click on the yellow' ...
  '   label "y" at the bottom edge of the figure.' ...
  '   Hold the mouse button down on that' ...
  '   same label to advance continuously.' ''...
  '\bullet Click on the black bar below the plot' ...
  '   to select the Y axis starting point.' '' ...
  '\bullet Press the start button to view the animation.' ...
  '   Press the same button to stop the animation.' '' ...
  '\bullet Move the five sliders, and click on the' ...
  '   checkboxes to observe the effects.' '' ...
  '\bullet All the plt cursoring features you have learned' ...
  '   for 2D plots still work (zoom boxes, panning,' ...
  '   peak/valley, delta cursoring, etc.)' .03+.9i 'fontsize' 13 'color' [.9 .5 .5]};

z = zeros(800,200);
x = -150:49;  f = 2;  j = .04;  m = .3;
for k=1:800   if k==400 j=-j; m=-m; end;
              x=x+m;  f=f+j;  xx=x/f;
              y = 10*sin(xx)./xx;
              y(isnan(y)) = 1;
              z(k,:) = y;
end;
v = version;  f = '';
if v(1)>'6'   f = '\color{yellow}'; end;  % Matlab 6 doesn't support tex color changes
t = ['Displays sync function {\it' f 'sin(\pix)/x} with sweeping origin and frequency'];

pltwater(z,'nT',12,'skip',2,'x',10*(0:199)-500,'y',(0:799)/.7,'HelpText',htxt,...
        'TraceC',[0 .8 1],'CursorC',[1 1 0],'^FontSize',13,'Title',t,'LabelY','Zaxis',...
        'xy',[.17 .12 .81 .84],'HelpFile','*/apps/programming examples.htm#wfalltst');
