% pub1.m ------------------------------------------------------------
%
% Shows the use of the pltpub command to produce publication quality output
% and demonstrates some unusual graphics techniques such as multicolored
% lines and rotating text.
%
% ----- Author: ----- Paul Mennen
% ----- Email:  ----- paul@mennen.org
%
% The left side of the plot is a solution to this Congruent parts puzzle:
%
%        ********************************************************
%        **                                                    **
%        **   Divide a circle into n congruent parts so that   **
%        **   at least one part does not touch the center.     **
%        **                                                    **
%        ********************************************************
%
% Now we compute the traces for the congruent parts solution ------------------------------
N=900;  cN = exp((1:N)*pi*2j/(N-1));  % 900 point unit circle
N6 = N/6;  b = 1:6;  na = NaN+b;
i = repmat([3 4 5 6 1 2]*N6,N6,1);    % index points for arc centers
d = cN + cN(i(:));                    % N point circle with translated centers
e = [reshape(transpose(d),N6,6); na]; % insert NaNs to eliminate stray lines
b = [na; cN(N6*b); d(N6*(b-.5))];     % draw the lines bisecting the 6 congruent parts
e = [e(:)' b(:)'];  cp = [.3 .3 .3];  % append the bisecting lines to the 6 arcs (grey color)
q = 5;  Nq = N/q;  q1 = ones(1,q);    % change color every 5 pixels, Nq = # of colors used
cm = hsv(Nq);  lw = 18*ones(1,2*Nq);  % colors and linewidth for the two multicolored circles
w = reshape(cN,q,Nq);                 % inside colored circle (no overlap)
u = cumsum([1 repmat([q1 0],1,Nq)]);  u(end) = [];  u(end) = 1;
h = reshape(1.1*cN(u),q+1,Nq);        % outside colored circle (1 pixel overlap)

% Next we compute some parametric curves which are plotted  on the right side of the figure
os = complex(1.8,.37);                                 % position offset for parametric curves
t0 = pi*(0.32  : .011 : 1.5);  r0 = 1.4 ./ (t0.^.8);  p0 = os - r0.*exp(t0.*1j); % text spiral
t1 = pi*(0.485 : .001 : 6.5);  r1 = 2.3 ./  t1;       p1 = os - r1.*exp(t1.*1j); % red spiral
t2 = pi*(2.485 : .001 : 9.2);  r2 =  92 ./ (t2.^2);   p2 = os - r2.*exp(t2.*1j); % blue spiral
t3 = pi*( 0    : .002 : 6.0);  p3 = os + (exp(t3.*1j) - 2.5*exp(t3.*-2j/3))/42;  % hypotrochoid
c0 = [0 0 0];  c1 = [1 0 0];  c2 = [0 0 1];  c3 = [0 .6 0];            % colors for p0,p1,p2,p3

% Next we display all the traces for both the congruent parts puzzle and the parametric curves
pltpub(e,h,w,p1,p2,p3,'Pos',[8 8 1373 840 25],'xy',[0 0 1 1],'LineWidth',[12 lw 5 5 2],...
   'TraceC',[cp; cm; cm; c1; c2; c3],'Xlim',[-1.2 2.92],'Ylim',[-1.2 1.2]);
set(findobj(gcf,'user','grid'),'color','white')

% Next we render the text elements on top of the parametric curves
t1 = text(1.427,.660,'r = 1/\theta',     'color',c1);
t2 = text(1.237,.843,'r = 40/\theta^ ^2','color',c2);
set([t1 t2],'fontname','Calibri','fontsize',20,'fontangle','italic','rotation',50);
e  = 'Archimedian spiral';  f = 'Lucida Console';
for k=1:length(e)
  m = 5*k+1;  v = p0(m+5) - p0(m-5);  a = 9+angle(v)*180/pi; % text size, position, and angle
  text(real(p0(m)),imag(p0(m)),e(k),'color',c0,...           % create one character at a time
      'fontname',f,'rotation',a,'fontsize',225*abs(v));
end;
