% pltmap.m ------------------------------------------------------------------
%
% The main purposes of this function is to demonstrate the use of the image pseudo object,
% and to demonstrate 2-dimensional cubic interpolation and 2-dimensional convolution.
%
% Click on the Help tag in the menu box to get details about how the two plots are created
% and the function of all the controls
%

% ----- Author: ----- Paul Mennen
% ----- Email:  ----- paul@mennen.org

function pltmap(in1)

p = [.021:.037:.17 .226:.037:.38]';                % 10 slider x positions
q = [.747 .014 .18 .03];                           % slider positions [y width height labelWidth]
ywh = [.7086 .1892 .2771];                         % [y width height] for blue/red boxes
p = {[-1 .005 .275 .04 .15; -2 .005 .09 .04 .17];  % positions: TraceID & Menubox
     num2cell([p repmat(q,10,1)],2);               % 10 slider positions {[x y width height labelWidth] ... }
     {[.0075 ywh] [.2117 ywh]};                    % positions: blue box, red box (around sliders)
     [.423 .59 .014 .27]; [.015 .47 .014 .18];     % positions: res and speed sliders
     [.043 .435 .04 .16]; [.44 .32 .017 .17 .02];  % positions: count popup and Kernal slider
     [.428 .320 .06 .19]; [.44 .09 .017 .16];      % positions: Kernal popup and Kernel scale slider
     [.04  .61 .03  .03]};                         % positions: Run button
ctrace = [010000 015300 010100 530147 005901 010101];                       % trace colors
Ktypes = {'uniform' 'conv11' 'pascal' 'reverse' 'edge' 'cubic' 'nearest'};  % convolution kernal types
if exist('Ktypes') Ki = 6; else Ki = 1; end;                                % startup kernal type
% Now create 6 traces. The first 5 traces will be on the left subplot and the last
% trace will be on the right subplot which will be used to create the intensity map
S.l = pltinit(0,zeros(1,6),'Pos',[830 550],'xy',p{1},'pos',[1200 700],'TIDcback',@cdata,...
       'Xlim',{[0 10];[0 10]},'Ylim',[0 10],'Styles','oooooo','LabelX',{'' ''},...
       'Options','-X-Y','FigBKc',001212,'HelpFile','*/apps/programming examples.htm#pltmap',...
       'MotionZoom',@zom,'TRACEc',ctrace,'Subplot',[67.96 -40.94 100.96 -61.02]);
S.cn = text(-.15,.805,'100','units','norm','color',[.31 .5 1],'user',warning('off'));
% Note: Warnings are turned off in the line above to suppress the annoying warnings
% produced by the griddata command. The previous warning states are saved so that
% they can be restored when the program exits. The following line tells plt to do this.
% Actually this is only needed for very old Matlab versions because newer Matlab
% versions automaically save the warning states and restores them when a program exits.
a = getappdata(gcf,'axis');  set(a,'Ylim',[0 10]);
setappdata(gcf,'ucreq','warning(get(findobj(gcf,"color",[.31 .5 1]),"user"));');
S.ax = gca;   rand('state',0);  cid = get(gca,'user');
tid = cur(cid,'TraceIDs'); tid = [tid; tid]; % create 10 amplitude sliders ----------
S.sli = plt('slider',p{2},num2cell(10*[rand(10,1) repmat(0:1,10,1)],2),tid,@cdata,1,'3');
plt('box',p{3},{[0 0 .4] [.3 0 0]});         % blue/red  boxes around Y/Z amplitude sliders
S.sl = flipud(findobj(gcf,'sty','slider'));  % save just the 10 slider uicontrols
S.res = plt('slider',p{4},[200 25 800 5 3200],'Res ',@cdata,[4 25]);
S.spd = plt('slider',p{5},[20 1 100],'Speed','',2);
S.cnt = plt('pop',p{6},100*[.05 .1 .2 .5 1 2 5 10],'index',5);
S.ksz = plt('slider',p{7},[5 1 25],'',@kern,2);  obj = plt('slider',S.ksz,'get','obj');
S.ker = plt('pop',p{8},Ktypes,@kern,'index',Ki,'labely','Kernel','hide',obj(2));
S.ksc = plt('slider',p{9},[5 1 20],'scale',@kern,2);
S.run = uic('string','Run','pos',p{10},'callback',@run);
s = '------------- Y amplitudes -------------';
text(-.24,1.465,s,'units','norm','color',[.9 .9 .3]);  s(15)='Z';
text( .42,1.465,s,'units','norm','color',[.9 .9 .3]);
S.img = -1;                % indicate that we haven't yet created the intensity map
setappdata(0,'cmaps',[]);  % clear previously defined colormaps
set(gcf,'user',S); kern;   % initialize the intensity map
% if nargin run(S.run); end;             % start running if an argument was provided
if nargin funcStart({@run S.run}); end;  % alternate to above. Allows immediate return

function kern(a,b)                  % kernel type and size callbacks
  S = get(gcf,'user');
  n = plt('slider',S.ksz);
  b = poly(kron(-1,ones(n-1,1)));   % b is the nth row of pascal's traingle
  b = repmat(b/max(b),n,1);         % normalize, then replicating the row n times
  b = min(b,b');                    % for case 3: pascal
  switch plt('pop',S.ker)
    case 1,  b = ones(n,n)/4;                                                  % uniform
    case 2,  b = 1;  for k = 2:n b = conv2(b,ones(2,2)); end;  b=b/max(b(:));  % conv11
    case 4,  b = (1-b)/4;                                                      % reverse
    case 5,  b = (b == b(1,1))/4;                                              % edge
  end;
  setappdata(gcf,'ker',plt('slider',S.ksc)*b/20);  cdata;

function zom(a)
  cur(-2,'xylim',a);

function cdata
  S = get(gcf,'user');  if ~isstruct(S) return; end;
  kr = plt('pop',S.ker);  terp = kr>5;                   % true to use cubic or linear interpolation
  usez = terp & (plt('slider',S.ksz) > 1);               % true to use the Z amplitude sliders
  if usez scl = 'scaled'; else scl = 'direct'; end;      % choose scaling type
  if terp & ~exist('terp') kr=7; end;                    % don't use cubic for compiled version
  xg=[]; yg=[]; az=[]; ix=[]; si=[]; t=0:99; tt = ones(size(t));
  vs = get(getappdata(S.ax,'Lhandles'),'vis');
  for k=5:-1:1 vis(k) = strcmp(vs{k},'on'); end;         % visible traces
  if ~sum(vis(1:3)) vis(1)=1; end;                       % must have one nonlinear trace active
  rs = plt('slider',S.res);
  if ~terp | ~exist('rs') rs = round(rs/3); end;  % use lower resolutions for convolutions or compiled version
  z = zeros(rs,rs);  idx = [224 190 160 130 70];  ss = 25.6;    % red,orange,yellow,green,blue
  if getappdata(0,'Mver') < 8.04  idx = idx/4; ss = ss/4; end;  % earlier Matlab versions use length 64 colormaps
  rs1 = rs - 1;  rs0 = 0:rs1;  rs2 = [rs rs];  ids = idx/ss;
  if ishandle(S.img)                              
       AX = get(S.img,'parent'); xl = get(AX,'xlim');  yl = get(AX,'ylim');  % here if image object exists
  else                           xl = [0 10];          yl = xl;              % no image object (use default limits)
  end;
  dx = diff(xl);  x = rs0*dx/rs1 + xl(1);
  dy = diff(yl);  y = rs0*dy/rs1 + yl(1);
  for k=1:5                                           % cycle thru all 5 traces
    if ~vis(k) continue; end;                         % skip the invisible traces
    ay = max(plt('slider',S.sli(k)),.1);              % get the y amplitude
    if usez      az = [az plt('slider',S.sli(k+5))];  % get the z amplitude from sliders
    elseif terp  az = [az ids(k)];                    % use z amplitude to match colors from left hand plot
    end;
    switch(k)
      case 1, Z = 0.5*ay*exp(.02i*t*pi);                                    % circle
              X=min(max(real(Z)+5,.5),9.5); Y=min(max(imag(Z)+5,.5),9.5);
      case 2, Z = exp([-25:-1 1:25] * pi * .018i);                          % hyperbola
              X=1./real(Z); Y=0.2*ay*X .* imag(Z)+5; X=[5-X 5+X]; Y=[Y Y];
      case 3, d = floor(ay); ay=ay-d; a=2*pi/(5+d); e = mod(d,2);           % polygon
              c = max(8*(e+(1-2*e)*ay),.04);  s = .0404*t*pi;
              v = c*cos(a)./cos(mod(s-pi/2,2*a)-a);  Z = v .* exp(1i*s);
              X=min(max(real(Z)+5,0),10);  Y=min(max(imag(Z)+5,0),10);
      otherwise, X = .05+t/10; Y=0*X+2*ay; if ay>5 XX=X; X=Y-10; Y=XX; end; % horiz/vert lines
    end;
    set(S.l(k),'x',X,'y',Y);
    if terp xg = [xg X];  yg = [yg Y];
    else    xi = min(max(floor(1 + rs*(X - xl(1))/dx),1),rs)';
            yi = min(max(floor(1 + rs*(Y - yl(1))/dy),1),rs)';
            sj = sub2ind(rs2,yi,xi);  si = [si sj];  ix = [ix idx(k)*tt];
    end;
  end;
  if terp  hh = repmat(ss*az,length(t),1);  hh = hh(:);
          [xi,yi] = meshgrid(x,y);                        % n x n grid (n = resolution slider value)
          if kr==6 z = griddata(xg,yg,hh,xi,yi,'cubic');  % compute z matrix using cubic interpolation
          else     z = nearest(xg,yg,hh,xi,yi);           % compute z matrix using nearest neighbor
          end;
  else    z(si) = ix;  b = getappdata(gcf,'ker');
          z = conv2(z,b,'same');
          z(si) = ix;
  end;
  if ishandle(S.img)                              % has the image pseudo object been created?
       plt('image',S.img,'xyz',x,y,z);            % yes, modify the image pseudo object
  else opt = {'Cbar' 'grid' 'view'};              % no, define image pseudo object options
       S.img = plt('image',2,x,y,z,opt);          % create the image pseudo object
       set(gcf,'user',S);                         % save image handle
       c = colormap('jet');  c(1,3) = 0;          % use jet color map except change first entry to black
       plt('image',S.img,'cbar',{'jetB',c});
       AX = get(S.img,'parent');
       cur(-2,'axisCB',@cdata);
  end;
  if ~strcmp(get(S.img,'CdataMap'),scl) set(S.img,'CdataMap',scl); end;
  if usez zstat = get(S.img,'user'); set(AX,'clim',zstat(1) + [-1 1]*zstat(2)); end;  % limit range to 1 std
% end function cdata

function z = nearest(xg,yg,hh,xi,yi)
  n = length(xi);  z = zeros(n,n);
  for row = 1:n
    for col = 1:n  [d,j] = min((xi(row,col)-xg).^2 + (yi(row,col)-yg).^2);  z(row,col) = hh(j);  end;
  end;

function run(a,b,c)
  if nargin>2 a = c; end;                       % for funcStart callback
  if sum(get(a,'string')) == 422                % does the button say "Stop"
    set(a,'string','Run'); return;              % yes, change it to say "Run"
  end;
  set(a,'string','Stop');                       % no, change it to say "Stop"
  sc = [1 1 .1 1 1 1 3 3 3 3 3]/300;            % polygon amplitude slider moves slower
  S=get(gcf,'user'); xlbl=get(S.ax,'XLabel');
  tic; cn=0; cnt=0;  dir = 2*mod(0:9,2)-1;      % direction: dir = +1/-1 (up/down)
  while ishandle(a) & sum(get(a,'string'))==422 % loop until Stop button is pressed
    if ~cnt mv = find(rand(1,10)>.5);           % every S.cnt updates, choose a new set
            if isempty(mv) | mv(1)>5  mv = [1 mv]; end; % ensure at least one Y slider active
            cnt=str2num(get(S.cnt,'string'));   % of sliders to move around
            set(xlbl,'str',prin('%.2f updates/sec',cn/toc));
            set(S.sl,'vis','off');
            set(S.sl(mv),'vis','on');           % Only show the siders that are moving
    end;
    s = plt('slider',S.spd) .* sc;
    for k=mv  v = plt('slider',S.sli(k)) + s(k)*dir(k);
              if v>10 | v<0 dir(k) = -dir(k);  v = min(max(v,0),10); end;
              plt('slider',S.sli(k),'val',v);
    end;
    cnt=cnt-1;  cn=cn+1;  set(S.cn,'string',sprintf('%d',cnt));
    if ishandle(a) cdata; end; drawnow;
  end;
  if ishandle(a) set(S.sl,'vis','on'); end;
% end function run