% pltSig.m (compiled version of demoplt.m)

function pltSig(in1)
  verString = 'ver 05Jul24';
  if exist(inifile('pltSig.txt')) erip; return; end; % pltSig starts erip if file ini\pltSig.txt exists
  if ~nargin in1 = 'init'; end;
  fg = findobj('name','pltSig');
  cfile = inifile('pltSig.mat'); % use plt\ini\pltSig.mat to save figure position & colors
  ed = findobj(fg,'style','edit');
switch in1
case 'close',  % here for close request function
      close(findobj('name','Color Pick'));  % close any open ColorPick windows
      if isempty(fg) return; end;
      fbk = get(fg,'color');  bbk = get(ed,'backgr'); fpos = get(fg,'pos');
      if any(get(gcf,'user') ~= [fbk bbk fpos])        % has setup changed?
        delete(get(gcf,'child'));  set(gcf,'user',0);  % yes, come here
        p = [220 85 250 32];  dp = [0 60 0 0];  p = {p+dp p p-dp };
        uic('Pos',p,'Callback',prin('{set(gcf,"user",%d);!row}',1:3),...
            'Str',{'Save setup changes' 'Exit without saving' 'Reset to default settings'});
         while ~get(gcf,'user') pause(.03); end; % wait for user to hit one of the 3 buttons
        switch get(gcf,'user')
        case 1, save(cfile,'fbk','bbk','fpos'); % save .mat setup
                disp('pltSig setup saved to pltSig.mat');
        case 3, delete(cfile); disp('pltSig.mat was deleted');
        end;
      end;
      closereq; % close the pltSig figure
case 'help',  % help button callback
  ff = 'doc/apps/pltSig.exe.htm';  fc = strrep(inifile('plt.chm'),'ini\','');  % help topic & help file
  if ispc dos(['hh ' fc '::' ff]);             % for windows systems, display with chm utility
  else if length(fc)>6 fc = fc(1:end-7); end;  % otherwise display topic using the browser
       feval('web',['file:///' fc ff]);
  end;
case {'init','go','Go'}
  fcn = {'plt5'       'plt50'     'pltn'      'vbar'        'wrkspace'   'movbar run' 'trigplt'    ...
         'subplt'     'subplt8'   'subplt16'  'subplt20'    'picplot'    'pltmap run' 'gui1'       ...
         'wfalltst'   'wfall run' 'pub0'      'pub1'        'pub2'       'pub3'       'xChart'     ...
         'afilt'      'editz'     'erip'      'fseries run' 'psdZoom'    'weight'     'winplt'     ...
         'airspeed'   'carlo 25'  'circles12' 'curves go'   'gauss'      'gpsLog'     'hermite'    ...
         'julia'      'motion run'                                                                  };
  if length(in1) < 4                                         % here for "pltSig go"
    setappdata(0,'pltSig',0);  T0=clock;                    % allow timing measurement
    for f=fcn  g = f{1};  k = strfind(g,' ');
               if length(k) g = g(1:k-1); elseif length(strfind(g,'12')) g = [g ' a'];  end;
               eval(g);  if in1(1)=='G' pause(1); end;       % 'Go' will pause after each demo
               close all;                                    % 'go' will not add any pauses
    end;
    rmappdata(0,'pltSig');                                  % terminate startup script
    disp(sprintf('Elapsed time: %.2f sec',etime(clock,T0)));
    return;
  end;
  if length(fg) disp('pltSig is already running'); return; end;
  if exist(cfile) load(cfile);       % get setup infromation from .mat if it exists
  else            fbk = [ 0 .2 .3];  % Otherwise: figure background color
                  bbk = [ 0  1 .6];  %            button background color (first 21 buttons)
                  fpos = [];         %            use default figure position
  end;
  fg = figure('name','pltSig','menu','none','numberT','off','double','off',...
              'pos',figpos([1510 0 610 200]),'color',fbk,'closereq','pltSig close;');
  [y x] = meshgrid(172:-22:62, 10:86:526);  x = x(:);  y = y(:);  z = 0*x;
  bt = uic('Str',fcn,'Pos',num2cell([x y z+78 z+18],2));  % create 37 buttons
  for k=1:length(fcn) set(bt(k),'callb',{@OneDemo,fcn{k}}); end;
  bt = [bt; uic('pos',[542 57 44 23],'str','help','callback','pltSig("help");');
            uic('pos',[354 57 164 23],'user',0,'str','All Programs',...
                'enable','inactive','buttond',{@AllP,fcn})];
  set(bt,'units','norm','fontsize',10,'backgr',bbk);
  set(bt(22:28),'backgr',[1 1 .4]);  set(bt(29:end-1),'backgr',[1 .3 1]);
  set(bt(end-1:end),'backgr','white','fontw','bold','fontsize',11);     % All Programs and Help buttons
  axes('pos',[0 0 1 1],'units','norm','vis','off'); % create an axis to contain the text objects
  set([text(.135,.093,'button color:') text(.375,.093,'figure backgr:')],'color','white','horiz','right');
  p = {[.142 .0534 .043 .0673];   % a(1) position: button color frame
       [.383 .0348 .107 .1114]};  % a(2) position: figure background editbox
  a = uic('Style',{'frame';'edit'},'Backgr',{bbk; bbk},'Enable',{'inactive' 'on'},'Pos',p,...
          'Buttond',prin('{plt ColorPick pltSig(%d);!row}',1:2));
  set(a(2),'string',strrep(prin('{%3w!  }',fbk),'0.','.'),'fontW','bold','callback',get(a(2),'buttond'));
  text(.585,.2,' ','color','yellow','fontsize',13);
  text(.87,.07,verString,'color',[.9 .5 .5],'fontsize',9);
  setappdata(a(1),'m',{'backgr',a(1),'backgr',bt(1:21)','button color'});
  setappdata(a(2),'m',{'string',a(2),'color', fg,'figure background'});
  if length(fpos) set(fg,'pos',fpos); else fpos = get(fg,'pos'); end;
  set(gcf,'user',[get(fg,'color') get(a(2),'backgr') fpos]); % save starting configuration
otherwise,        % here to do the color callback function
  if ischar(in1) disp([in1 ' is not a valid pltSig argument']); return; end;
  bt = findobj('style','pushbutton');  btc = get(bt(end),'backgr');
  t = {'           Button'    'Figure background'};
  c = {get(bt(end),'backgr')  get(fg,'color')    };
  disp(sprintf('      %s color was changed to [%.2f %.2f %.2f]',t{in1},c{in1}));
  set(findobj('style','edit'),'backgr',c{1}); % edit box color tracks button color
end % end switch in1
%end function pltSig

function FGclose() % close all figures except the pltSig figure
  a = get(0,'child');  d = findobj('name','pltSig');
  for k = 1:length(a)  if a(k)~=d delete(a(k)); end; end;
  setappdata(0,'CurMain',[]);
  g = findobj(gcf,'style','push','backgr','black'); % find the active button
  set(g,'backgr',get(g,'foregr'),'foregr','black'); % reset it to its former color
%end function FGclose

function OneDemo(h,arg2,func)
  FGclose;
  arg = '';  fun = func;  k = strfind(fun,' ');
  if length(k)  fun = fun(1:k-1);  arg = func(k+1:end); end;
  setappdata(0,'FigName',fun);
  if ~ishandle(h) if strcmp(fun,'circles12') arg = '1';  else  arg = '';  end;  end;
  g = findobj(gcf,'string',func); % change active button to reverse video
  set(g,'foregr',get(g,'backgr'),'backgr','black');
  if length(arg) feval(fun,arg); else feval(fun); end;
  a = get(0,'child');                % list of all the figure windows
  b = findobj(a,'name','pltSig');   % find pltSig in the list
  if length(b) set(0,'child',[b; a(find(a~=b))]); end; % force pltSig window on-top
%end function OneDemo

function AllP(h,arg2,fcn)   % Run all the programs in sequence
  mouse  = get(gcf,'SelectionT');   nf = length(fcn);
  et = findobj(gcf,'fontsize',13);  set(et,'string','');
  if mouse(1) == 'a'
    t0=clock;  for n=1:nf  OneDemo(-1,0,fcn{n}); end;  FGclose;
    set(et,'string',sprintf('Elapsed time: %.2f sec',etime(clock,t0)));
  else     
    n = get(h,'user') + 1;  % function to start
    if n>nf
      set(h,'user',0,'string','All Demos');
      FGclose;
      set(findobj(gcf,'fontsize',13),'string','ALL DEMOS COMPLETED');
    else set(h,'user',n,'string','continue');
         OneDemo(0,0,fcn{n});  p = [230 580 400 65];
         if n==1  figure('Pos',figpos(p),'NumberT','off','Menu','none','color',[16 16 16]/17);
                  uicontrol('style','text','Pos',[10 10 380 50],'fontsize',16,'str',...
                  'To see the remaining demo programs, keep pressing the continue button.');
         elseif n==2 delete(findobj('type','figure','Name',''));
         end;
    end;
  end;
%end function AllP
