% picplot.m ----------------------------------------------------------------
%
% This is the simplest example that demonstrates the use of the image pseudo object.
% A jpeg image (from the plt documentation section) is read in, converted to indexed color,
% and then plotted using plt and the image pseudo object.  Running this program gives you
% a good opportunity to  experiment with the cursoring, zooming, panning, and data editing
% techniques with image data.
%
% The input argument specifies the picture to display. For example:
% picplot C:\users\paul\Pictures\myFavorite.jpg
%
% If no input argument is given, the file glider.jpg is read from the plt\ini folder.
%
% The selected image file is displayed in color using the colorcube image map. If you want to
% see the image in black & white (i.e. greyscale), check the gray checkbox below the plot

% ----- Author: ----- Paul Mennen
% ----- Email:  ----- paul@mennen.org

function picplot(f)
  if ~nargin f = inifile('glider.jpg'); end; % use picture from ini folder if filename not provided
  p = imread(f);                                                          % load the picture
  pg = double(p);  pg = .114*pg(:,:,1) + .587*pg(:,:,2) + .299*pg(:,:,3); % convert to grayscale
  [y x] = size(pg);  t = sprintf('%s  (%d x %d) [TexOff]',f,x,y);
  x = 1:x;  y = y:-1:1;                                                      % 1st row of image is at the top
  pltinit(x,x,'Pos',[700 635],'Options','T-X-Y','LabelX','','LabelY','',...  % create image axis
          'Title',t,'HelpFile','*/apps/programming examples.htm#picplot');
  if getappdata(0,'Mver') < 8.04  pg = pg/4;  end;  % earlier Matlab versions use length 64 colormaps
  if exist('rgb2ind')              % old matlab versions don't have rgb2ind
    cbar = 'cbar5';                % convert to indexed color using the colorcube map
    pc = double(rgb2ind(p,colorcube,'nodither')) + 1;
  else  pc = pg;  cbar = 'cbar4';  % if we don't have rgb2ind, just use the grayscale map
  end;
  set(gcf,'user',{plt('image',1,x,y,pc,{cbar 'direct'}) pc pg});  % create image
  uicontrol('style','checkbox','string','gray','pos',[390 10 50 21],'callback',@checkbx);
% end function picplot

function checkbx(a,b)  % checbox callback
  v = get(gcbo,'value');  z = get(gcf,'user');
  plt('image',z{1},'z',z{v+2},'cbar',5-v);
% end function checkbx