% gui1.m --------------------------------------------------------
%
% Usually plt is used to build gui applications which include plotting,
% however this example doesn't include plots so that it remains trivial,
% making it a good example to start with if you have no previous exposure
% to Matlab GUI programming. Three different pseudo objects are used,
% the pseudo slider, the pseudo popup, and the pseudo box. The remaining
% controls used in gui1 are standard matlab uicontrols.
%
% This GUI doesn't actually perform any useful function other than to
% demonstrate how to create various controls and move them around
% until the GUI appears as desired. The slider callback generates new
% random numbers for the listbox and textbox. The remaining callbacks
% simply notify you that you clicked on the object.
%
% Please address any questions or comments you may have about this example,
% or plt in general to me at the email address shown below.
%
% ----- Author: ----- Paul Mennen
% ----- Email:  ----- paul@mennen.org

function gui1()
  figure('name','gui1','menu','none','pos',[90 90 430 350],'color',[0 .3 .2]);
  cho = {'choice A' 'choice B' 'choice C'}; % choices for popup control
  p = {[.020 .920 .300     ];  % PseudoSlider 1
       [.350 .920 .300     ];  % PseudoSlider 2
       [.680 .920 .300     ];  % PseudoSlider 3
       [.270 .500 .250 .200];  % Pseudo popup
       [.540 .500 .440 .280];  % Pseudo box
       [.030 .560 .200 .060];  % radio button
       [.680 .710 .170 .050];  % popup
       [.570 .610 .380 .060];  % slider
       [.570 .520 .170 .060];  % button
       [.780 .520 .170 .060];  % checkbox
       [.015 .040 .500 .410];  % listbox (80 lines)
       [.540 .040 .440 .410]}; % text (10 lines)
%  p = arrange(12);       % comment this out once the final positions are imported

% Next create all 12 objects and save their handles in the h array.

  h = [plt('slider',p(1:3),{10 60 800},{'Slider 1' 'Slider 2' 'Slider 3'},@CBsli);
       plt('pop',p{4},cho,'disp("pseudo popup")','label','PSEUDO POPUP');
       plt('box',p{5});
       uic('Style', {'radio'      'popup' 'slider' 'pushb'   'checkbox' 'listbox' 'text'},...
           'String',{'RadioButton' cho    'slider' 'button1' 'check001' ''        ''    },...
           'Callb', { @CB          @CB     @CBsli   @CB       @CB       ''        ''    },...
           'backgr',500101,'Pos',p(6:end))];

  set(gcf,'user',h);  CBsli; % save the handles for the slider callback and execute it

function CB(a,b)         % default uicontrol callback ---------------
  disp(get(a,'style'));  % display the uicontrol style

function CBsli(a,b)             % The slider callback -------------------
  h = get(gcf,'user');          % get the handle list
  r = 1e20.^(rand(3,80))/1e6;   % generate some random numbers
  % Use the same random table of numbers for both the listbox and the textbox
  set(h(11:12),'string',prin('3{%6V  }~, ',r),'fontname','courier');
