% demoplt.m ------------------------------------ (plt version 12Jul24)
%
%   *******************************************************
%   *******************************************************
%   **                                                   **
%   **   GREEN  BUTTONS:   plt features                  **
%   **   YELLOW BUTTONS:   signal processing topics      **
%   **   PURPLE BUTTONS:   engineering and math topics   **
%   **                                                   **
%   *******************************************************
%   *******************************************************
%
% This program makes it easy to run any of the 37 application and demo programs by clicking on the
% button labled with the program name. After installing plt, it is a good idea to to run demoplt
% and to click on the "All Demos" button. This will verify that plt has been installed properly
% and more importantly it will give you an overiew of the types of plots that are possible using plt.
%
% As each demo is run, you may peruse the code for the demo program currently being run by using the
% scrollbar on the right side of the list box. Note that the number of lines of code (not counting
% the comment lines) appears in the lower right corner of the figure to give you an idea of the
% complexity of each example. If the text is to big or small for your taste, adjust the fontsize
% using the fontsize popup menu in the lower right corner of the demoplt figure.
%
% For more information on the use of demoplt, click on the white "help" button just to the right
% of the "All Programs" button
%
% ----- Author: ----- Paul Mennen
% ----- Email:  ----- paul@mennen.org

function demoplt(in1)
  if ~nargin in1 = 'init'; end;
  fg = findobj('name','demoplt');
  cfile = inifile('demoplt.mat'); % use plt\ini\demoplt.mat to save figure position & colors
  bx = findobj(fg,'style','listbox');    pu = findobj(fg,'style','popup');
switch in1
case 'close',  % here for close request function
      close(findobj('name','Color Pick'));  % close any open ColorPick windows
      if isempty(fg) return; end;
      fbk = get(fg,'color');  lbk = get(bx,'backgr');  lfg = get(bx,'foregr');
      bbk = get(pu,'backgr'); fpos = get(fg,'pos');   fsz = get(bx,'fontsize');
      if any(get(gcf,'user') ~= [fbk lbk lfg bbk fpos fsz])  % has setup changed?
        delete(get(gcf,'child'));  set(gcf,'user',0);        % yes, come here
        p = [220 240 250 32];  dp = [0 60 0 0];  p = {p+dp p p-dp };
        uic('Pos',p,'Callback',prin('{set(gcf,"user",%d);!row}',1:3),...
            'Str',{'Save setup changes' 'Exit without saving' 'Reset to default settings'});
         while ~get(gcf,'user') pause(.03); end; % wait for user to hit one of the 3 buttons
        switch get(gcf,'user')
        case 1, save(cfile,'fbk','lbk','lfg','bbk','fpos','fsz','-v4'); % save .mat setup
                disp('demoplt setup saved to demoplt.mat');
        case 3, delete(cfile); disp('demoplt.mat was deleted');
        end;
      end;
      closereq; % close the demoplt figure
case 'help',  % help button callback
  ff = 'doc/apps/demoplt.htm';  fc = strrep(inifile('plt.chm'),'ini\','');  % help topic & help file
  if ispc dos(['hh ' fc '::' ff]);             % for windows systems, display with chm utility
  else if length(fc)>6 fc = fc(1:end-7); end;  % otherwise display topic using the browser
       feval('web',['file:///' fc ff]);
  end;
case {'init','go','Go'}
  fcn = {'plt5'       'plt50'     'pltn'      'vbar'        'wrkspace'   'movbar run' 'trigplt'    ...
         'subplt'     'subplt8'   'subplt16'  'subplt20'    'picplot'    'pltmap run' 'gui1'       ...
         'wfalltst'   'wfall run' 'pub0'      'pub1'        'pub2'       'pub3'       'xChart'     ...
         'afilt'      'editz'     'erip'      'fseries run' 'psdZoom'    'weight'     'winplt'     ...
         'airspeed'   'carlo 25'  'circles12' 'curves go'   'gauss'      'gpsLog'     'hermite'    ...
         'julia'      'motion run'                                                                  };
  if length(in1) < 4                                         % here for "demoplt go"
    setappdata(0,'demoplt',0);  T0=clock;                    % allow timing measurement
    for f=fcn  g = f{1};  k = strfind(g,' ');
               if length(k) g = g(1:k-1); elseif length(strfind(g,'12')) g = [g ' a'];  end;
               eval(g);  if in1(1)=='G' pause(1); end;       % 'Go' will pause after each demo
               close all;                                    % 'go' will not add any pauses
    end;
    rmappdata(0,'demoplt');                                  % terminate startup script
    disp(sprintf('Elapsed time: %.2f sec',etime(clock,T0)));
    return;
  end;
  if length(fg) disp('demoplt is already running'); return; end;
  if exist(cfile) load(cfile);       % get setup infromation from .mat if it exists
  else            fbk = [ 0 .2 .3];  % Otherwise: figure background color
                  lbk = [ 0  0  0];  %            listbox background color
                  lfg = [ 1  1 .5];  %            listbox foreground (text color)
                  bbk = [ 0  1 .6];  %            button background color (first 21 buttons)
                  fpos = [];         %            use default figure position
                  fsz = 9;           %            default listbox fontsize
  end;
  fg = figure('name','demoplt','menu','none','numberT','off','double','off',...
              'pos',figpos([1510 0 610 464]),'color',fbk,'closereq','demoplt close;');
  [y x] = meshgrid(442:-22:332, 10:86:526);  x = x(:);  y = y(:);  z = 0*x;
  bt = uic('Str',fcn,'Pos',num2cell([x y z+78 z+18],2));  % create 37 buttons
  for k=1:length(fcn) set(bt(k),'callb',{@OneDemo,fcn{k}}); end;
  bt = [bt; uic('pos',[542 328  44 22],'str','help','callback','demoplt("help");');
            uic('pos',[354 328 164 22],'user',0,'str','All Programs',...
                'enable','inactive','buttond',{@AllP,fcn})];
  set(bt,'units','norm','fontsize',10,'backgr',bbk);
  set(bt(22:28),'backgr',[1 1 .4]);  set(bt(29:end-1),'backgr',[1 .3 1]);
  set(bt(end-1:end),'backgr','white','fontw','bold','fontsize',11);  % All Programs and Help buttons
  bx = uic('style','listbox','pos',[.014 .073 .974 .622],...         % listbox for viewing demo code
           'fontsize',fsz,'fontname','Lucida Console','foregr',lfg,'backgr',lbk);
  axes('pos',[0 0 1 1],'units','norm','vis','off'); % create an axis to contain the text objects
  v=version;  v=v(1:4); if v(4)=='.' v(4)=v(3);  v(3) ='0'; end; v=sscanf(v,'%f');
  % e.g. for version 9.8, v =  9.08 so that v is always larger for later versions
  if (v<8.4) ytx = .037; else ytx = .042; end; % use different positions before R2014b
  set([text(.170,ytx,'text fore/backgr:') ...
       text(.405,ytx,'button color:') ...
       text(.595,ytx,'figure backgr:')],'color','white','horiz','right');
  setappdata(gcf,'nL',text(.9,ytx,'','color',[1 1 0],'fontw','bold')); % # of code lines
  set(bx,'string',rdfunc('demoplt'));
  p = {[.174 .020 .043 .029];  % a(1) position: text color frame
       [.224 .020 .043 .029];  % a(2) position: text background frame
       [.409 .020 .043 .029];  % a(3) position: button color frame
       [.603 .012 .107 .048];  % a(4) position: figure background editbox
       [.728 .013 .139 .048]}; % a(5) position: fontsize popup
  a = uic('Style',{'frame';'frame';'frame';'edit';'popup'},'Backgr',{lfg; lbk; bbk; bbk; bbk},...
          'Enable',{'inactive' 'inactive' 'inactive', 'on' 'on'},'Pos',p,...
          'Buttond',prin('{plt ColorPick demoplt(%d);!row}',1:5));
  set(a(4),'string',strrep(prin('{%3w!  }',fbk),'0.','.'),'fontW','bold','callback',get(a(4),'buttond'));
  set(a(5),'string',prin('{fontsize: %d!row}',4:18),'value',fsz-3,'fontsize',9,'buttond','',...
           'callback','set(findobj(gcf,''sty'',''l''),''fontsize'',3+get(gcbo,''value''));');
  setappdata(a(1),'m',{'backgr',a(1),'foregr',bx,'text color'});  % define color pick actions
  setappdata(a(2),'m',{'backgr',a(2),'backgr',bx,'text background'});
  setappdata(a(3),'m',{'backgr',a(3),'backgr',[a(5) bt(1:21)'],'button color'});
  setappdata(a(4),'m',{'string',a(4),'color', fg,'figure background'});
  if isempty(fpos) & (figpos('height')>999 & isempty(getappdata(0,'pltSmall')))
    fpos = figpos([1660 5 730 502]); % use a bigger demoplt figure for large screen sizes
  end;
  if length(fpos) set(fg,'pos',fpos); else fpos = get(fg,'pos'); end;
  set(gcf,'user',[get(fg,'color') get(bx,'backgr') get(bx,'foregr') ...
                  get(a(5),'backgr') fpos get(bx,'fontsize')]); % save starting configuration
otherwise,        % here to do the color callback function
  if ischar(in1) disp([in1 ' is not a valid demoplt argument']); return; end;
  t = {'Text foreground  ' 'Text background  ' 'Button           ' 'Figure background'};
  c = { get(bx,'foregr')    get(bx,'backgr')    get(pu,'backgr')    get(fg,'color')   };
  s = sprintf('      %s color was changed to [%.2f %.2f %.2f]',t{in1},c{in1});
  set(bx,'string',[{s}; get(bx,'string')]);        % report color change on the listbox
  set(findobj('style','edit'),'backgr',c{3});  % edit box color tracks button color
end % end switch in1
%end function demoplt

function s=rdfunc(func) % returns a cell array of strings from a program file
  f = strfind(func,' ');
  if length(f) func = func(1:f-1); end;
  f = fopen(which(func));  s = {};
  htxt = 0;  nL = 0;   % counts lines (not counting comments and on-sreen HelpText)
  while 1  ln = fgetl(f);
           if ~ischar(ln), break, end
           s = [s; {ln}];
           if length(strfind(ln,'htxt =')) htxt = 1; end;
           ln = deblank(fliplr(ln));
           if length(ln) & (ln(end)~='%') & ~htxt  nL=nL+1;  end;
           if length(strfind(ln,'}'))  htxt = 0; end;
  end
  set(getappdata(gcf,'nL'),'str',prin('%d lines',nL));
  fclose(f);
%end function rdfunc

function FGclose() % close all figures except the demoplt figure
  a = transpose(get(0,'child'));
  a(find(a==findobj('name','demoplt'))) = [];
  close(a);
  g = findobj(gcf,'style','push','backgr','black'); % find the active button
  set(g,'backgr',get(g,'foregr'),'foregr','black'); % reset it to its former color
%end function FGclose

function OneDemo(h,arg2,func)        % Run one of the demos or applications
  FGclose;  arg = '';  fun = func;  k = strfind(fun,' ');
  if length(k)  fun = fun(1:k-1);  arg = func(k+1:end); end;
  if ~ishandle(h) if strcmp(fun,'circles12') arg = '1';  else  arg = '';  end;  end;
  g = findobj(gcf,'string',func);    % change active button to reverse video
  set(g,'foregr',get(g,'backgr'),'backgr','black');
  set(findobj(gcf,'style','listbox'),'val',1,'string',rdfunc(func));
  if strcmp(func,'wrkspace')
       evalin('base',func);
  else if length(arg) feval(fun,arg); else feval(fun); end;
  end;
  a = get(0,'child');                % list of all the figure windows
  b = findobj(a,'name','demoplt');   % find demoplt in the list
  if length(b) set(0,'child',[b; a(find(a~=b))]); end; % force demoplt window on-top
%end function OneDemo 

function AllP(h,arg2,fcn)            % Run all the programs in sequence
  mouse  = get(gcf,'SelectionT');   nf = length(fcn);
  if mouse(1) == 'a'
    t0=clock;  for n=1:nf  OneDemo(-1,0,fcn{n}); end;  FGclose;
    s = sprintf('Elapsed time: %.2f sec',etime(clock,t0)); disp(s);
    set(findobj(gcf,'style','listbox'),'value',3,'string',{'' '' s});
  else     
    n = get(h,'user') + 1;  % function to start
    if n>nf
      set(h,'user',0,'string','All Demos');
      FGclose;
      set(findobj(gcf,'style','listbox'),'string',{'' '' '   --- ALL DEMOS COMPLETED ---'});
    else set(h,'user',n,'string','continue');
         OneDemo(0,0,fcn{n});  p = [230 580 400 65];
         if n==1  figure('Pos',figpos(p),'NumberT','off','Menu','none','color',[16 16 16]/17);
                  uicontrol('style','text','Pos',[10 10 380 50],'fontsize',16,'str',...
                  'To see the remaining demo programs, keep pressing the continue button.');
         elseif n==2 delete(findobj('type','figure','Name',''));
         end;
    end;
  end;
%end function AllP
