function [Ret1,Ret2] = cur(varargin)  % plt cursor commands (version 12Jul24)
%function [Ret1,Ret2] = cur(CurID,Action,In1,In2,In3,In4,In5,In6,In7,In8,In9,In10)
%
%   Pseudo Object providing cursor & display expansion control
%
%   No expansion box visible:
%     Left click on or near a line and the cursor will jump to the line
%     AND the line is selected for value readout, peak/valley finding
%     or marking for delta x/y.
%
%     Left click on or near a line and drag, and the cursor will track on the line.
%     Left click inside the axis will also drag the cursor, but won't change the
%     line the cursor is on (if there were multiple lines).
%
%     Double click and HOLD after the 2nd click drag opens an expansion box.
%
%     The ^ button will find peaks of the data on the selected line
%     The v button finds valleys
%
%     Clicking the delta button marks a line at the current cursor position. Subsequent clicks
%     on the line will readout the cursor position and the difference from the marker.
%     The expand is disabled in delta mode. Click the delta button again to turn this mode off.
%
%   With expansion box open:
%     editing readout text specifies expansion coords and exp. box shows results
%     left click expands to box coordinates and right click cancels the expansion mode
%
%   Action
%   'init'
%           CurID  = [owner axis    handle of owner axis
%                       aux axis]   (optional) handle of aux axis
%
%                   Locations for cursor objects (IN PIXELS)
%           In1 = [ x y w h    x label              1
%                   x y w h    y label              2
%                   x y w h    x cursor readout     3
%                   x y w h    x cursor expansion   4
%                   x y w h    y cursor readout     5
%                   x y w h    y cursor expansion   6
%                   x y w h    peak button          7
%                   x y w h    valley button        8
%                   x y w h    delta button (mark)  9
%                   x y w h    line markers button  10
%                   x y w h];  x cursor slider      11 (OPTIONAL)
%
%           In2 = [ r g b      label color
%                   r g b      readout color  (if [0 0 0] track associated line color)
%                   r g b      expansion box color
%                   r g b      delta line color
%                   r g b      cursor color for cursor  #1 (if [0 0 0] use associated line color)
%                   r g b];    cursor/expansion line color for each cursor #2 (optional)
%                              must have r g b for each line object that has a cursor
%                  If In2 is empty the default is: [.7 .7 .7; 0 0 0; 1 1 .51; 1 0 0; 0 0 0];
%
%           In3 = ['xlabel'    x & y labels
%                  'ylabel']   or may use {'xlabel','ylabel'}
%                              If In3 is empty, ['x';'y'] is used
%
%           In4 = stylestr     cursor LineStyle e.g. '+','o','x'
%                              must have a Line Style for each line that has
%                              a cursor.
%           In5 = cursor size  eg. 6... 28 (points) MarkerSize (one size fits all)
%
%           In6 = [fmtxro      format string for x readout
%                  fmtyro]     format string for y readout
%                              e.g ['%2.1f';'%6.1f'] or {'%2.1f','%6.1f'}
%                              Note that this argument is optional.
%                              If In6 not included or is empty ['%7w';'%7w'] is used
%
%           In7 =              visible 'on' / 'off' (optional)
%           In8 =              monotonic flag (optional)
%                              set to 1 if data will have a monotonic x component
%                              set to 0 if it will not (e.g. Nyquist plots)
%                              leave undefined and test will be done to determine
%                              x monotonicity.
%           In9 =              axis limit change callback (optional) executed when axis limits
%                              are changed
%           In10 =             TraceIDs - if this argument is included, the TraceIDs will be saved
%                              in the appdata of one of the cursor objects so that it can be
%                              retrieved using a cur(CurID,'TraceIDs') command
%
%           Ret1 =             returns cursor ID needed for calling program to
%                              communicate with the cursor (integer)
%
%   For cursor calls OTHER THAN 'init',  CurID is set to an internally assigned integer that
%   was returned to the calling program in Ret1 during the init phase.
%
%   Action
%   ----------
%   'visON'          visibility of all cursor objects, normal cursor state resored (no expand, no delta)
%   'visOFF'
%   'aux'            In1='on'/'off' to show or hide aux cursor & its readout
%   'setObjPos'      reset position of objects with In1 per definition of 'init' action
%   'xlab'           x readout label
%   'ylab'           y readout label
%   'xylim'          set new xylimits, update expansion history
%                    In1=[xmin,xmax,ymin,ymax]
%                    In2=[ymin,ymax] for aux axis (optional)
%   'ylim'           new y limits, update y expansion history
%                    In2=[ymin,ymax] for aux axis (optional)
%   'xlim'           new x limits, update x expansion history
%   'exRestore'      restores array of expansion history and sets axis
%   'clrpk'          clears peak/valley finder data
%   'axisCB',cback   user defined callback function when an axis limit change occurs
%   'axisCB2,cback   auxiliary axis limit callback function (usually internally defined)
%   'moveCB',cback   user defined callback when cursor moves
%   'moveCB2',cback  auxiliary user defined callback when cursor moves (usually internally defined)
%   'setActive'      In1 is new active line number.
%                    In2 (optional) is the initial cursor index (default = 1)
%   'get'            returns cursor position for a line number In1 (optional)
%                    if no line number is given, assumes active cursor
%   'expHis'         returns expansion history
%   'getActive'      returns active Ret1=line number and Ret2=handle to same (useful for overlayed line implementation)
%   'update'         Moves to the cursor index indicated by In1 (defaults to current position)
%                    In2,In3 is x,y cursor position (if you want the cursor off the line)
%   'peakval'        In1=0 (move to peak) or In2=1 (move to valley)
%   'clear'          clear ID slot in CurMain. To be a good citizen. This action should be
%                    executed when a cursor is no longer needed.
%   'MVcur'          set text & color of the cursor ID tag (moveCB2)
%   'panAX'          pan axes
%   'expbox'         draw an expansion box
%   'axisCB'         AXIS callback method
%   'lineCB'         LINE callback method
%   'AxisCBr'        clicked on right hand axis
%   'editCB'         edit box callback method
%   'svHist'         save expansion history after panning or zooming
%   'scale'
%   'xincr'          x axis label callback
%   'xslider'        xaxis slider control
%   'peakval'        Peak / Valley finder (what will it do with a relation ?)
%   'restore'        terminate expansion & restore cursor readout
%   'markCB'
%   'mlsCB'
%   'clear'          delete cursor objects & clear out slot
%   'scaleAxis'      scaleAxis
%   'ZoomOut'        zoom axis in/out
%   'mark'           Add a marker at current cursor location
%   'TGLlogy'        Toggle the y-axis from lin to log (or back)
%   'TGLlogx'        Toggle the x-axis from lin to log (or back)
%   'TraceIDs'       Returns a character array containing the current plot's TraceIDs
%   'Emode'          Changes persistent editing mode

%
%
%
%
%

%
%
    Ret1 = 0;  Ret2 = 0;
    Narg = nargin;
    if Narg>2  v1 = varargin{1}; 
               if length(v1)==1 & ishandle(v1)
                 v2 = varargin{2};
                 if length(v2) < 2  varargin(1:2)=[]; Narg=Narg-2; end;
               end;
    end;

    Mver = getappdata(0,'Mver');
    MverE = (Mver<8.04);
%
    Action = 'update';  CurID = -1;
    if MverE  ERAS = 'eras';  ERAXOR = 'xor';  ERANOR = 'norm';
    else      ERAS = 'pi';    ERAXOR = 'v';    ERANOR = 'v';
    end;
    In1 = '';  In2 = '';  In3 = '';  In4 = '';  In5 = '';
    In6 = '';  In7 = '';  In8 = '';  In9 = '';  In10 = '';
    if Narg
       CurID = varargin{1};
       if Narg > 1
          Action = varargin{2};
          if Narg > 2
            In1 = varargin{3};
            if Narg > 3
              In2 = varargin{4};
              if Narg > 4
                In3 = varargin{5};  if iscell(In3) In3 = char(In3); end;
                if Narg > 5
                  In4 = varargin{6};
                  if Narg > 6
                    In5 = varargin{7};
                    if Narg > 7
                      In6 = varargin{8};  if iscell(In6) In6 = char(In6); end;
                      if Narg > 8
                        In7 = varargin{9};
                        if Narg > 9
                          In8 = varargin{10};
                          if Narg > 10 In9 = varargin{11};
                            if Narg > 11 In10 = varargin{12}; end;
                          end;
                        end;
                      end;
                    end;
                  end;
                end;
              end;
            end;
          end;
       end;
    end;
    CurMain = getappdata(0,'CurMain');
    sact = sum(lower(Action));
    if sact ~= 436
%
%
%
%
%
%

      if ischar(CurID) CurID = sscanf(CurID,'%d'); end;
      if ~CurID CurID = getappdata(gcf,'cidP');
      elseif CurID<0 tmp = getappdata(gcf,'cid');  CurID = -CurID;
                     if CurID>length(tmp) return; else CurID = tmp(CurID); end;
      end;
      if CurID > length(CurMain) disp('invalid cursorID'); return; end;
      Hc = CurMain(CurID);  if ~ishandle(Hc) return; end;
      Hc = get(Hc,'userdata');
      if length(Hc)<15 disp('invalid cursor ID'); return; end;
      ax = Hc(14);  ax2 = Hc(15);
      if isempty(get(ax2,'par')) ax2 = []; end;
      axrl = [ax ax2];
      cFG = get(ax,'par');
      setappdata(cFG,'cidP',CurID);

      axlink = 0;
      if ishandle(ax2)
           if ~isVIS(ax2)  ax2=[];
           else axlink = [get(get(ax2,'ylab'),'str') '  '];
                axlink = axlink(1)~=92 | axlink(2) ~= 'd';
           end;
      end;
      hix = Hc(4);  hiy = Hc(6);
      misc = get(hix,'userdata');
      actv = misc(4);
      iact = 15 + actv;
      ix   = misc(1);
      hact = Hc(iact);
      lh = get(hact,'userdata');
      lk = lh{1};
      Ret1 = hact;  Ret2 = lk;
      if ~ishandle(hact) return; end;
      xylim = [get(ax,'xlim') get(ax,'ylim')];
      xyli = xylim;
      if get(hact,'par')==ax2 xyli(3:4) = get(ax2,'ylim'); end;
      DualCur = getappdata(ax,'DualCur');
    end;
    Narg2=Narg;
    switch sact
    case 436
      if MverE Hc = zeros(1,15);
      else     Hc = feval('gobjects',1,15);
      end;
      ax = CurID(1);
%
      DualCur = getappdata(ax,'DualCur');
      if isempty(DualCur) DualCur = 0;  setappdata(ax,'DualCur',0); end;
      Hc(14) = ax;
      if length(CurID)==2  ax2 = CurID(2);  ax2a = ax2; else ax2 = [];  ax2a = 0; end;
      Hc(15) = ax2a;
      hf = get(ax,'par');
%
      if isempty(In7) vis='on'; else vis=In7; end;
%
%
      Cn = length(CurMain);
      f = find(~CurMain);
      if length(f) CurID = f(1);
      else CurMain = [CurMain 0]; CurID = Cn+1;
      end;
      if CurID>200 disp('Warning: Clear actions missing for 200 cursor inits'); end;
      Ret1 = CurID;
      setappdata(gcf,'cidP',CurID);
      CurIDstr  = {@cur CurID};
      if getappdata(gcf,'indep') CurIDstr0 = {@cur 0}; else CurIDstr0 = CurIDstr; end;
%
      hLines = getappdata(ax,'Lhandles');
%
%
%
      skp = get(hLines,'tag');
      if ~iscell(skp) skp = {skp}; end;
      hLines = hLines(cellfun('length',skp) ~= 7);
      axes(ax);
%
      set(gcf,'vis','of');
%
      if isempty(In2)
         cEXPbox = [1 1 .51];  if sum(get(gca,'color'))>2 cEXPbox=1-cEXPbox; end;
         In2 = [.7 .7 .7; 0 0 0; cEXPbox; 1 0 0; 0 0 0]; end;
      trk = ~sum(In2(2,:));
      if length(hLines)
         In2n = length(In2(:,1));
         clines = length(hLines);
         cli4 = clines + 4;
         if In2n < cli4
%
           In2 = In2(min(1:cli4,In2n*ones(1,cli4)),:);
%
         end;
         In4n = length(In4);
         if In4n<clines
           In4 = In4(min(1:clines,In4n*ones(1,clines)));
%
         end;
         In2n     = length(In2(:,1));
         objColor = In2(5:In2n,:);
         tact = 0;
         if length(ax2) hLines2 = findobj(ax2,'type','line');
         else           hLines2 = 0;
         end;
         if MverE  Hc = [Hc zeros(1,clines)];
         else      Hc = [Hc feval('gobjects',1,clines)];
         end;
         for i=1:clines
            hi = hLines(i);
            xy = [get(hi,'x'); get(hi,'y')];
            if sum(objColor(i,:)) curColor = objColor(i,:);
            else                  curColor = get(hi,'color');
            end;
            Hc(15+i)=line('x',xy(1,1),'y',xy(2,1),ERAS,ERAXOR,'color',curColor,'linestyle','none',...
                            'clipping','on','vis',vis,'userdata',{hi trk});
            set(Hc(15+i),'marker',In4(i),'MarkerSize',In5);
%
            set(hi,'buttond',[CurIDstr {'lineCB' i}]);
            if ~tact & isVIS(hi) tact = i; end;
            if length(find(hi==hLines2)) set(Hc(15+i),'par',ax2); end;
         end;
      else disp('no lines to attach cursors to')
      end;
      if max(max(In1))>2 unitt = 'Pixels'; else unitt = 'Normal'; end;
%
      fontsz = (196-get(0,'screenpix'))/10;
      for i=2:3
        if i==2  cbStr  = 'x'; else cbStr  = 'y'; end;
        cbStr= [CurIDstr {'scaleAxis' cbStr}];
        if isempty(In3) In3 = ['x';'y']; end;
        Hc(i) = uicontrol(hf,'Style','text','fontsi',fontsz,'vis',vis,'str',deblank(In3(i-2+1,:)),...
                'Units',unitt,'pos',In1(i-1,:),'backg',In2(1,:),'horiz','cent','buttond',cbStr,'ena','inact');
      end;
      bd1 = 'plt click EDIT '; bd2 = {'1;' '6 1;' '2;' '6 3;'};
      for i=4:7
        cbStr  = [CurIDstr {'editCB' i-4}];
        bdStr  = [bd1 bd2{i-4+1}];
        Hc(i) = uicontrol(hf,'Style','edit','fontsi',fontsz,'vis',vis,'str',' ','Units',unitt,'pos',In1(i-1,:),...
            'foreg',[0 0 0],'horiz','left','callback',cbStr,'buttond',bdStr,'tag',sprintf('%d',CurID));
      end;
      set(Hc([5 7]),'vis','of');
      hix = Hc(4);  hiy = Hc(6);
%
      ih = [8 9 10 11];  c = [173 175 79 68];
      cbs = {{'peakval' 0} {'peakval' 1} {'mlsCB' ''} {'markCB' ''}};
      cbk = CurIDstr0;
      for k = 1:4
        m = ih(k);    pt = In1(m-1,:);
        if pt(1)<0 break; end;
        if k==4 cbk = CurIDstr; end;
        Hc(m) = uicontrol(hf,'Units',unitt,'pos',In1(m-1,:),'vis',vis,'horiz','cent',...
                  'str',char(c(k)),'fontname','symbol','fontw','bol','callback',[cbk cbs{k}]);
      end;
      if k==1
        if MverE  Hc(8:11) = -1;
        else      Hc(8:11) = feval('gobjects');
        end;
      else
        set(Hc(8), 'ui',uicontextmenu('callback',[cbk {'peakval' 2}]));
        set(Hc(9),'ui',uicontextmenu('callback',[cbk {'peakval' 3}]));
        set(Hc(10),'ui',uicontextmenu('callback',[cbk {'rstyle'}]));
        set(Hc(11),'fontsi',12,'ui',uicontextmenu('callback','plt misc rdelta;'));
        setappdata(gcf,'peak',-inf); setappdata(gcf,'vall',inf);
      end;
      Hc(13) = line('x',[],'y',[],ERAS,ERAXOR,'color',In2(4,:),'vis','of');
      set(Hc(13),'marker','+','MarkerSize',5*In5,'tag','DeltaC');
      if isempty(In6) In6 = ['%7w';'%7w']; end;
      set(Hc(3),'userdata',In6);
      if length(In1(:,1)) >= 11
        uicontrol(hf,'style','slider','Units',unitt,'pos',In1(11,:),...
             'backg',[.3 .3 .3],'Min',0,'Max',1000,'val',500,'userdata',500,...
             'vis',vis,'callback',[CurIDstr {'xslider'}],'tag','xslider');
      end;
      set(get(ax,'xlab'),'buttond',[CurIDstr {'xincr'}]);
      i = [CurIDstr {'axisCB'}];
      Hc(12) = line('x',[],'y',[],ERAS,ERAXOR,'vis','of','color',In2(3,:),'buttond',i);
      set([hf ax],'buttond',i);
%
      if isempty(In8) monoFlag = -1; else monoFlag = In8; end;
      set(Hc(5),'userdata',In9);
      misc = zeros(1,8);
      if length(ax2) set(ax2,'buttond',[CurIDstr {'AxisCBr'}]); end;
%
      misc(5) = monoFlag;
      misc(4) = max(1,tact);
      set(hix,'userdata',misc);
      set(Hc(7),'userdata',''); setappdata(Hc(7),'CB2','');
      set(Hc(2),'userdata',Hc);
      numLines = length(Hc)-15;  ct = cellstr(In10); 
      ct = ct(1:min(numLines,length(ct)));  if length(ct)==1 & isempty(ct{1}) ct = {}; end;
      setappdata(Hc(2),'TraceIDs',ct);
      CurMain(CurID) = Hc(2);
      setappdata(0,'CurMain',CurMain);
%

%
    case 536
%
%
%
%
      p0 = getappdata(get(ax,'xlab'),'OldCur');
      sc = get(ax,'yscale');  liny = sc(2)=='i';
      if ischar(In1)
          aPt = get(ax2,'currentp');  cy = aPt(1,2);
          y = get(ax2,'ylim');
          if liny  y = y + p0(2) - cy;
          else     y = y * p0(2) / cy;
          end;
          set(ax2,'ylim',y);
      else
        aPt = get(ax,'currentp');
        cx = aPt(1,1);  cy = aPt(1,2);
        if In1<1 x = xylim(1:2);
                 sc = get(ax,'xscale');
                 if sc(2)=='i' x = x + p0(1) - cx;
                 else          x = x * p0(1) / cx;
                 end;
                 set(axrl,'xlim',x);
        end;
        if In1   y = xylim(3:4);
                 if liny  yi = p0(2) - cy;  y = y + yi;
                 else     yi = p0(2) / cy;  y = y * yi;
                 end;
                 set(ax,'ylim',y);
                 if axlink
                   yr = get(ax2,'ylim');
                   if liny  yr = yr + yi * diff(yr)/diff(y);
                   else     yr = yr * (yr(2)/yr(1))^(log(yi)/log(y(2)/y(1)));
                   end;
                   set(ax2,'ylim',yr);
                 end;
        end;
      end;
      plt('grid',ax);
      fixMark;
%
    case 670
      p0 = getappdata(get(ax,'xlab'),'OldCur');
      if ischar(In1)
          aPt = get(ax2,'currentp');
          y = get(ax2,'ylim');  y0 = y(1);  y1 = y(2);
          cy = aPt(1,2)-y0;  if ~cy cy=1e-06; end;
          set(ax2,'ylim',[y0 y0 + abs((p0(2)-y0)*(y1-y0)/cy)]);
      else
        aPt = get(ax,'currentp');
        if In1<1 x0 = xylim(1);  x1 = xylim(2);
                 cx = aPt(1,1)-x0;  if ~cx cx=1e-06; end;
                 set(axrl,'xlim',[x0 x0 + abs((p0(1)-x0)*(x1-x0)/cx)]);
        end;
        if In1   y0 = xylim(3);  y1 = xylim(4);  dy = y1-y0;
                 cy = aPt(1,2)-y0;  if ~cy cy=1e-06; end;
                 cy = dy/cy;  p2 = p0(2)-y0;
                 set(ax,'ylim',[y0 y0 + abs(p2*cy)]);
                 if axlink
                    sc = get(ax,'yscale');
                    if sc(2)=='i'
                       y = get(ax2,'ylim');  y0 = y(1);  y1 = y(2);
                       p2 = (y1-y0) * p2 / dy;
                       set(ax2,'ylim',[y0 y0 + abs(p2*cy)]);
                    else
                       yr = get(ax2,'ylim');  yr0 = yr(1);  yr1 = yr(2);
                       aPt = get(ax2,'currentp');
                       cy = aPt(1,2)-yr0;  if ~cy cy=1e-06; end;
                       p0 = yr0 * exp(log(p0(2)/y0) * log(yr1/yr0) / log(y1/y0));
                       set(ax2,'ylim',[yr0 yr0 + abs((p0-yr0)*(yr1-yr0)/cy)]);
                     end;
                 end;
        end;
      end;
      plt('grid',ax);
      fixMark;
%
    case 662
      expbx = Hc(12);  set(hact,'vis','of');
      if DualCur
        if DualCur>0 dact=15+DualCur;
        else dact = iact-DualCur;
             if dact > length(Hc) dact=iact+DualCur; end;
        end;
        set(Hc(dact),'vis','of');
      end;
      aPt  = get(ax,'currentp');
      xCur = max(xylim(1),min(xylim(2),aPt(1,1)));  yCur = max(xylim(3),min(xylim(4),aPt(1,2)));
      aPt   = get(expbx,'userdata');
      xOld  = aPt(1);  yOld  = aPt(2);
%
%
      if sum(get(ax,'yscale')) == 322
            dxyOk = abs(log(xylim(3)/xylim(4))) < 50 * abs(log(yOld/yCur));
      else  dxyOk = diff(xylim(3:4)) < 50 * abs(yOld-yCur);
      end;
      if dxyOk
         if sum(get(ax,'xscale')) == 322
               dxyOk = abs(log((.0001*xylim(2)+xylim(1))/xylim(2))) < 50 * abs(log(xOld/xCur));
         else  dxyOk = diff(xylim(1:2)) < 50 * abs(xOld-xCur);
         end;
      end;
      if dxyOk
          set(expbx,'x',[xOld xCur xCur xOld xOld],'y',[yOld yOld yCur yCur yOld]);
          f2 = get(Hc(3),'userdata');  f1 = f2(1,:);  f2 = f2(2,:);
          if ~isVIS(expbx)
             set(hix,'str',Pftoa(f1,xOld));  set(hiy,'str',Pftoa(f2,yOld));
             set(expbx,'vis','on');  set(Hc(4:7),'ena','on');
             set2(Hc(11),'ena','of');
          end;
          bf = {'backg'; 'foreg'};  
          set(Hc([5 7]),{'str'},prin([f1 ' ~; ' f2],xCur,yCur),bf,get(hix,bf),'vis','on');
      end;
      mZoom([xOld xCur yOld yCur]);
%
    case 712
      aPt  = get(ax,'currentp');  new = complex(aPt(1,1),aPt(1,2));
      expbx = Hc(12);   xy = get(expbx,'userdata');  old = xy(1);
      xy = xy(2:end) + new - old;  x = real(xy);  y = imag(xy);
      set(expbx,'x',x,'y',y);
      f2 = get(Hc(3),'userdata');  f1 = f2(1,:);  f2 = f2(2,:); s = ' ~; ';
      set(Hc(4:7),{'str'},prin([f1 s f1 s f2 s f2],x(1:2),y(2:3))); 
      mZoom([x(1:2) y(2:3)]);
%
    case {634, 621},
      setappdata(cFG,'cidR',CurID);
      if sact==634 & Narg2>2 & ~isnumeric(In1) set(Hc(5),'userdata',In1); return; end;
      b = get(hact,'buttond'); if length(b) & ischar(b) eval(b); return; end;
      clkType = sum(get(gcf,'SelectionT'));
      co = cur(CurID,'obj');  ye = find(get(co(2),'str') == [168 62 68]);
      expbx = Hc(12);
      boxVis = isVIS(expbx);
      aPt  = get(ax,'currentp');  cx = aPt(1,1);  cy  = aPt(1,2);
      xCur = max(xylim(1),min(xylim(2),cx));
      yCur = max(xylim(3),min(xylim(4),cy));
      dxy = diff(xylim);
      smv = '';
      StopMotion = 'set(gcf,''WindowButtonMotionFcn'','''',''WindowButtonUpFcn'','''');';
      CurIDstr = {@cur CurID};
%
      if ~boxVis & ~misc(7) & ~misc(8)
         if     cx<xylim(1) | cx>xylim(2)   dragy =  1;
         elseif cy<xylim(3) | cy>xylim(4)   dragy =  0;
         else                               dragy = -1;
         end;
         if clkType == 649 | (length(ye) & clkType==321 & sact==621)
            ovt = 0;
%
            if sact==634
               Narg2 = 3;
%
%
               if isVIS(lk)
                  for i=15+1:length(Hc)
                      lh = get(Hc(i),'userdata');  lk = lh{1};
                      if isVIS(lk) break; end;
                  end;
                  actv = i-15;
               end;
               In1 = actv;
%
%
%
               if length(ax2)
                 ylm = get(ax2,'ylim');  dylm = diff(ylm);
                 cvert = (cy - xylim(3)) / dxy(3);
                 mdst = 1e+99;
                 idst = 0;
                 for i=15+1:length(Hc)
                   if get(Hc(i),'par') ~= ax2 continue; end;
                   lh = get(Hc(i),'userdata'); lk = lh{1};
                   if ~isVIS(lk) continue; end;
                   x = get(lk,'x'); y = get(lk,'y');
                   if length(x)>999 | all(diff(x)>0)
                     [toss,j] = min(abs(xCur-x));
                     dvert = (y(j) - ylm(1)) / dylm;
                     acv = abs(cvert-dvert);
                   else
                     acv = min(abs((x-xCur)/dxy(1)) + abs((y-ylm(1))/dylm - cvert));
                   end;
                   if acv < mdst  idst = i;  mdst = acv; end;
                 end;
                 if mdst < .02
                   ovt = 1;
                   ii = idst-15;
                   if ii ~= DualCur In1 = ii; end;
                 end;
               end;
            end;
            lh = get(Hc(15+In1),'userdata'); lk = lh{1};
            x = get(lk,'x'); y = get(lk,'y');
            if Narg2==3
               setappdata(cFG,'peak',-inf); setappdata(cFG,'vall',inf);
               if misc(5)==-1
                  df = diff(x);
                  monoFlag = all(df>0) | all(df<0);
               else monoFlag = misc(5);
               end;
            else monoFlag=In2;
            end;
            if monoFlag [junk,imin] = min(abs(xCur-x));
%
%
%
            elseif get(lk,'par')==ax2
                  ylm = get(ax2,'ylim');  dylm = diff(ylm);
                  cvert = (cy - xylim(3)) / dxy(3);
                  [toss,imin] = min(abs((x-xCur)/dxy(1)) + abs((y-ylm(1))/dylm - cvert));
            else  [toss,imin] = min(abs((x-xCur)/dxy(1)) + abs(yCur-y)/dxy(3));
            end;
            actv = In1;  misc(4) = actv;
            iact = 15 + actv;
            hact = Hc(iact);
            set(hix,'userdata',misc);
            if length(getappdata(gca,'offline')) yimin = yCur;
            else                                 yimin = y(imin);
            end;
            drgy = dragy<0 | (length(getappdata(cFG,'subTr')) & dragy<=0);
            if ~isappdata(Hc(2),'hid') & drgy
              cur(CurID,'update',imin,x(imin),yimin);
            end;
            if (sact==621) | ovt
              if Narg2==3
                smv = [CurIDstr {'lineCB' In1 monoFlag 0}];
              end;
            else setappdata(get(ax,'xlab'),'OldCur',[cx cy xylim]);
                 StopMotion = [CurIDstr {'svHist'}];
                 smv = [CurIDstr {'panAX' dragy}];
            end;
         elseif clkType == 321
            setappdata(get(ax,'xlab'),'OldCur',[cx cy xylim]);
            StopMotion = [CurIDstr {'svHist'}];
            smv = [CurIDstr {'zoomAX' dragy}];
         else
            set(expbx,'userdata',[xCur yCur]);
            StopMotion = [CurIDstr {'expSwap'}];
            smv = [CurIDstr {'expbox'}];
         end;
      elseif boxVis | misc(7) | misc(8)
        if clkType==649
              cxy   = complex(cx,cy);  xyl13 = complex(xylim(1),xylim(3));  dxy13 = complex(dxy(1),dxy(3));
              cor5  = complex(get(expbx,'x'),get(expbx,'y'));
              cor = cor5(1:4);
              corn = divc(cor-xyl13,dxy13);
              edgn = (corn + corn([2 3 4 1]))/2;
              curn = divc(cxy-xyl13,dxy13);
              [cdst ci] = min(abs(curn-corn));
              [edst ei] = min(abs(curn-edgn));
              edst = edst/2;  dst = min(edst,cdst);
              StopMotion = [CurIDstr {'expSwap'}];
              if dst > .02 cur(CurID,'scale','new2');
              elseif dst==cdst
                   c = cor(mod(ci+1,4)+1); set(expbx,'userdata',[real(c) imag(c)]);
                   smv = [CurIDstr {'expbox'}];
              else set(expbx,'userdata',[cxy cor5]);  smv = [CurIDstr {'expbox2'}];
              end;
        else  cur(CurID,'restore');
        end;
        misc([7 8]) = 0;  set(hix,'userdata',misc);
      end;
      if length(smv) set(cFG,'WindowButtonMotionFcn',smv,'WindowButtonUpFcn',StopMotion); end;
      if clkType~=434 & sact==621 & length(ye)
        plt('click','Yedit',7+ye,0);
      end;
%
    case 748
      CurIDstr = {@cur CurID};
      aPt  = get(ax2,'currentp');  setappdata(get(ax,'xlab'),'OldCur',[aPt(1,1) aPt(1,2)]);
      if sum(get(gcf,'SelectionT'))==321 smv = [CurIDstr {'zoomAX' 'R'}];
      else          smv = [CurIDstr {'panAX'  'R'}];
      end;
      set(cFG,'WindowButtonMotionFcn',smv,'WindowButtonUpFcn','set(gcf,''WindowButtonMotionFcn'','''',''WindowButtonUpFcn'','''');');
%
    case 619
      s = get(Hc(4:7),'str');
      fmt = get(Hc(3),'userdata');
      editd = length(get(hact,'buttond'));
      for k=0:3
        ss = s{k+1};
        if k==In1 x = str2num(ss); j = 4+k;
                  if isempty(x) set(Hc(j),'str','invalid');  setappdata(cFG,'newtxt',ss);  return; end;
                  xi = imag(x);
                  if xi & k==2  xr = real(x);  a = get(hact,'par');
%
                                if ~xr setappdata(a,'eRes',[xi xi]); else setappdata(a,'eRes',[xr xi]); end;
                                if editd  plt xleft Yedit 4;  end;
                                set(Hc(j),'str','eRes set');
                                return; 
                  else set(Hc(j),'str',Pftoa(fmt(1+(k>1),:),x));
                  end;
        else      x = str2double(ss);
        end;
        w(k+1) = x;
      end;
%
      if isVIS(Hc(12)) | misc(7) | misc(8) 
         set(Hc(12),'x',w([1 2 2 1 1]),'y',w([3 3 4 4 3]));
         mZoom(w);
         cur(CurID,'expSwap');
      else
        if getappdata(cFG,'indep')>0
           ci = getappdata(Hc(4+In1),'indep');
           if length(ci)
              CurID = ci;
              if CurID > length(CurMain) disp('invalid cursorID'); return; end;
              Hc = get(CurMain(CurID),'userdata');
              if isempty(Hc) disp('invalid cursor ID'); return; end;
              setappdata(cFG,'cidP',CurID);
              ax = Hc(14);  ax2 = Hc(15);
              if isempty(get(ax2,'par')) ax2 = []; end;
              hix = Hc(4);  hiy = Hc(6);
              misc = get(hix,'userdata');
              actv = misc(4);
              iact = 15 + actv;
              hact = Hc(iact);
              lh = get(hact,'userdata');
              lk = lh{1};
              xyli = [get(ax,'xlim') get(ax,'ylim')];
              if get(hact,'par')==ax2 xyli(3:4) = get(ax2,'ylim'); end;
           end;
        end;
        xd = get(lk,'x');  yd = get(lk,'y');
        switch In1
          case 0, if editd set(hact,'x',w(1)); plt click EDIT 5 0; return; end;
                  [q ix] = min(abs(xd-w(1)));
          case 2, if editd set(hact,'y',w(3)); plt click EDIT 5 0; return; end;
                  [q ix] = min(abs(yd-w(3)));
          otherwise, return;
        end;
        xv = xd(ix);  yv = yd(ix);
        if xv<xyli(1) | xv>xyli(2) cur(CurID,'xlim',xv+[-.5 .5].*diff(xyli(1:2))); end;
        if yv<xyli(3) | yv>xyli(4) cur(CurID,'ylim',yv+[-.5 .5].*diff(xyli(3:4))); end;
        cur(CurID,'update',ix);
      end;
%
    case 776
      set(gcf,'WindowButtonMotionFcn','','WindowButtonUpFcn','');
      expbx = Hc(12);
      x = get(expbx,'x'); if length(x)<5 return; end; y = get(expbx,'y');
      if x(2)<x(1) x = x([2 1 1 2 2]);  set(expbx,'x',x);  s = get(Hc(5),'str');
                   set(Hc(5),'str',get(Hc(4),'str'));  set(Hc(4),'str',s);
      end;
      if y(3)<y(2) y = y([3 3 2 2 3]);  set(expbx,'y',y);  s = get(Hc(7),'str');
                   set(Hc(7),'str',get(Hc(6),'str'));  set(Hc(6),'str',s);
      end;
      a = getappdata(gca,'MotionZup');
      if length(a)
        b = [x(1:2) y(2:3)];
        if ischar(a)     feval(a,b);
        elseif iscell(a) a = [a {b}]; feval(a{:})
        else             a = {a b};   feval(a{:});
        end;
      end;
%
    case 673
      set(gcf,'WindowButtonMotionFcn','','WindowButtonUpFcn','');
      p0 = getappdata(get(ax,'xlab'),'OldCur');
      if any(xylim - p0(3:6))
        set(Hc(12),'x',[xylim(1:2) 0 0 0],...
                        'y',[xylim(3) 0 xylim(4) 0 0]);
        set(ax,'xlim',p0(3:4),'ylim',p0(5:6));
        cur(CurID,'scale','new',0,0);
      end;
%
    case 758
      updateS(ax,CurID);
%
    case {643 747 753}
%
%
%
      if isappdata(Hc(2),'hid') return; end;
      set(Hc(15+1:end),'vis','of');
      if ischar(In1) In1 = sscanf(In1,'%d'); end;
      if isempty(In1) | ~In1 In1 = ix; end;
      if ~isVIS(lk)
        for i=15+1:length(Hc)
          lh = get(Hc(i),'userdata'); lk = lh{1};
          if isVIS(lk) break; end;
        end;
        actv = i-15; misc(4) = actv;
        iact = 15 + actv;
        hact = Hc(iact);
        if ~ishandle(hact) return; end;
      end;
      if ~isVIS(lk) return; end;
      if isempty(In2)
        x = get(lk,'x');  y = get(lk,'y');  n = length(x);
        if ~n return; end;
        if In1>n | In1<=0
           [toss,In1] = min(abs(mean(xyli(1:2))-x));
         end;  
        In2 = x(In1);  In3 = y(In1);
      end;
      a = get(hact,'par');
      if length(getappdata(a,'subTr')) AXeval(Hc(5)); return; end;
      if a == ax  xyl = xylim;  else xyl = xyli; end;
      xlim = xyl(1:2);  ylim = xyl(3:4);
      xd = 1.01 * (In2-xlim);  yd = 1.01 * (In3-ylim);
      if xd(1)<=0 xlim = xlim + xd(1); elseif xd(2)>=0 xlim = xlim+xd(2); end;
      if yd(1)<=0 ylim = ylim + yd(1); elseif yd(2)>=0 ylim = ylim+yd(2); end;
      if ~isequal(xyl,[xlim ylim]) ...
           & sact==643 ...
           & isempty(getappdata(a,'hold'))
         setlim(a,'xlim',xlim); setlim(a,'ylim',ylim);
         if a==ax plt('grid',ax); end;
         AXeval(Hc(5));
      end;
      set(hact,'y',In3,'x',In2,'vis','on');
      tidcur = getappdata(ax,'tidcuR');
      if length(tidcur)
        if isnumeric(tidcur) tidcur = sprintf('%%%dv',tidcur); end;
        tx = cur(CurID,'obj');  tx = tx(16);  tx = findobj(tx,'type','text');
        for k = 1:length(tx)
           yy = get(tx(k),'buttond');  yy = get(yy{3}(1),'y');
           if In1<1 | In1 > length(yy) continue; end;
           st = get(tx(k),'str');    sc = find(st==':');
           if length(sc) st = st(1:max(1,sc(1)-1));  end;
           set(tx(k),'str',[st ': ' prin(tidcur,yy(In1))]);
        end;
      end;
      multi = getappdata(ax,'multi');
      if length(multi)
        Lha = getappdata(ax,'Lhandles'); n = length(Lha);
        for k = 1:n  yd = get(Lha(k),'y'); yd = yd(min(In1,length(yd)));
                     set(multi(k),'pos',[In2 yd],'str',prin(get(multi(k),'tag'),yd));
                     set(multi(k+n),'x',In2,'y',yd);
        end;
        set(multi(end),'x',[In2 In2]);
      end;
      bf = {'backg' 'foreg'};
      fmt = get(Hc(3),'userdata');
      lc = get(lk,'color');
      fr = repmat(max(lc.*[.9 1 .5])<=.5,1,3);
      set([hix hiy],{'str'},{Pftoa(fmt(1,:),In2); Pftoa(fmt(2,:),In3)},bf,{lc fr});
      dmode = isVIS(Hc(13));
      if dmode
         dxy = {Pftoa(fmt(1,:),In2-get(Hc(13),'x')); Pftoa(fmt(2,:),In3-get(Hc(13),'y'))};
         set(Hc([5 7]),{'str'},dxy,bf,get(hix,bf),'vis','on');
      end;
      if DualCur
        if DualCur>0 dact=15+DualCur; ow=0;
        else dact = iact-DualCur;
             ow = (dact > length(Hc));
             if ow dact=iact+DualCur; end;
        end;
        Hcd = Hc(dact);
        dh = get(Hcd,'userdata'); dk = dh{1};
        if isVIS(dk)
          xy = [get(dk,'x'); get(dk,'y')];
          misc(6) = xy(2,In1);
          xylen = length(xy(1,:)); if ix>xylen ix=xylen; end;
          yd = xy(2,In1);
          a = get(Hcd,'par'); b = get(a,'YaxisLoc');
          if b(1)=='r' b = get(a,'ylim'); yd = max(b(1),min(b(2),yd)); end;
          set(Hcd,'x', max(xyli(1),min(xyli(2),xy(1,In1))),'y',yd,'vis','on');
          if ~dmode set(Hc(5),'vis','of');
                    s = Pftoa(fmt(2,:),xy(2,In1));
                    if ow t = s;  s = get(Hc(6),'str'); set(Hc(6),'str',t); end;
                    dc = get(dk,'color');
                    fr = repmat(max(dc.*[.9 1 .5])<=.5,1,3);
                    set(Hc(7),bf,{dc fr},'str',s,'vis','on');
          end;
        end;
      end;
      misc([1 2 3]) = [In1 In2 In3];  set(hix,'userdata',misc);
      s = getappdata(Hc(7),'CB2');  evalQ(s);
%
%
%
%
%
      rep1 = updateS(ax,CurID);
      if length(getappdata(ax,'moveCBext')) | length(find(ax==findobj(cFG,'type','axes')))
        s = get(Hc(7),'userdata');
        if length(s) & sact~=753
          evalRep(s,rep1);
        end;
      end;
%
    case 520
      expHis = get(hiy,'userdata');
%
%
      if isempty(expHis) expHis = [xylim 1]; end;
      lExp   = length(expHis(:,1));
      curExp = find(expHis(:,5)==1);
      skip   = [];   In1S = sum(In1);  new2r = (In1S==380);
      switch In1S
      case {330 380}
         xy = Hc(12);  xy = [get(xy,'x') get(xy,'y')];
         expLim = [sort(xy(1:2)) sort(xy([6 8])) 1];
         if isequal(xylim,expLim(1:4))
            if length(curExp) expHis(curExp,5)=1; end;
         else
            if length(curExp)
               expHis(curExp,5)=0;
               if max(curExp,lExp) < 4
                  expHis = [expHis; expLim];
               else
                  if curExp==4  expHis(2:4,:)=[expHis(3:4,:); expLim];
                  elseif curExp >= 1  expHis(curExp+1,:)=expLim;
                  end;
               end;
            else
               if lExp < 4  expHis = [expHis; expLim];
               else               expHis = [expHis(lExp-1,:); expLim];
               end;
            end;
         end;
         autoScale=0;
      case 319
          if sum(get(gcf,'SelectionT'))==321 autoScale=1;
          else
            if isempty(curExp) curExp = lExp;
            else               expHis(curExp,5)=0;  curExp = curExp-1;
            end;
%
            if curExp  autoScale=0;  expLim=expHis(curExp,:); expHis(curExp,5)=1;
            else       autoScale=1;
            end;
          end;
      case 441
          switch sum(In2)
          case 120,    autoScale=2;
          case 121,    autoScale=3;
          case 429, autoScale=1;
          otherwise, disp([In2 ' is not a valid action in plt(cursor,CurID,scale,auto,In2)']);
          end;
      otherwise, disp([In1 ' is not a valid action in plt(cursor,CurID,scale,In1)']);
      end;
      if autoScale == 0
          setlim(ax,'xlim',sort(expLim(1:2)));
          setlim(ax,'ylim',sort(expLim(3:4)));
          wii = 0;
      else
%
         numLines=length(Hc)-15;  minx=+inf;  maxx=-inf;
         temp = zeros(numLines,2);  lineList = [];   wii = 1;
         for i=1:numLines
            hLine=get(Hc(15+i),'userdata');
            if isVIS(hLine{1})
               xdata = get(hLine{1},'x');
               minx  = min(minx,min(xdata));
               maxx  = max(maxx,max(xdata));
               if wii ydata = get(hLine{1},'y'); end;
               lineList = [i lineList];  wii = 0;
            end;
         end;

         if wii msgbox('Possible autoscale without any visible lines','Warning','warn','modal');
         else
            for i=1:numLines
              k = Hc(15+i);
              tx = get(k,'x');  ty = get(k,'y');
              temp(i,:) = [tx(1) ty(1)];
              set(k,'x',xdata(1),'y',ydata(1));
            end;
%
%
            skip = findobj(ax,'tag','SkipCur','vis','on'); set(skip,'vis','of');
            switch autoScale
            case 1,  set(ax,'YlimM','auto');
                         expLim = [minx maxx get(ax,'ylim') 1];
                         setlim(ax,'xlim',expLim(1:2));
            case 2, expLim = [minx maxx get(ax,'ylim') 1];
                         setlim(ax,'xlim',expLim(1:2));
            case 3,
               misc=get(hix,'userdata');
               if ismember(actv,lineList)
                  ydata = get(lk,'y');
                  ymax = max(ydata);  ymin = min(ydata);  dy = 0.25*(ymax-ymin);
                  ymin = ymin - dy;   ymax = ymax + dy;
                  if ymin ~= ymax  set(ax,'YlimM','man'); set(ax,'ylim',[ymin ymax]); drawnow;
                  else             set(ax,'YlimM','auto');  drawnow;
                  end;
               else set(ax,'YlimM','man'); drawnow; set(ax,'YlimM','auto');
               end;
               expLim = [xylim 1];
            end;
            for i=1:numLines set(Hc(15+i),'x',temp(i,1),'y',temp(i,2)); end;
         end;
      end;
      if ~wii
         if length(ax2) setlim(ax2,'xlim',expLim(1:2)); end;
         set(hiy,'userdata',expHis);
         if axlink & Narg<5
           yr = get(ax2,'ylim');
          setlim(ax2,'ylim',yr(1) + (get(ax,'ylim') - xylim(3)) * diff(yr) / (xylim(4)-xylim(3)));
         end;
         if new2r cur(CurID,'restore'); end;
         axes(ax); AXeval(Hc(5));
      end;
      set(ax,'YlimM','man');
      set(skip,'vis','on');
      plt('grid',ax);
      xView = getappdata(ax,'xView');
      if length(xView) set(xView{1},'x',get(ax,'xlim')); end;
%
    case 548,
%
      lx = length(get(lk,'x'));
      ty = sum(get(gcf,'SelectionT'));  dblclk = ty==434;
      if dblclk & getappdata(gcbo,'ty')==321 ty = 321; end;
      [rpt p] = getREPEAT;
      setappdata(cFG,'bdown',1);
      set(cFG,'WindowButtonUpFcn','setappdata(gcf,''bdown'',0);');
      while getappdata(cFG,'bdown')
        if ty==321 ix = max(ix-1,1);
        else        ix = min(ix+1,lx);
        end;
        setappdata(gcbo,'ty',ty);
        cur(CurID,'update',ix);
        if rpt < 0 | dblclk break; end;
        pause(p);  p = rpt;
      end;
    case 763,
      x = get(lk,'x');   y = get(lk,'y'); lx = length(x);
      xlim = xylim(1:2);   ylim = xylim(3:4);  dxlim = diff(xlim);
      v = get(gcbo,'val');  x1 = min(x);  x2 = max(x);   xrange = x2 - x1;
      if xrange/dxlim < 2
        dx = round(v - 500);
        if abs(dx)==10 pmove = .01; else pmove = .05; end;
        ix = max(min(lx,ix + sign(dx)*round(lx*pmove)),1);
        x = x(ix);  xd = 1.01 * (x-xlim);
        if xd(1)<0 xlim = xlim + xd(1); elseif xd(2)>0 xlim = xlim+xd(2); end;
        v = 500;
      else
        dx = v - get(gcbo,'userdata');
        switch round(abs(dx))
          case 10,   xlim = xlim + sign(dx)*dxlim/10;
          case 100,  xlim = xlim + sign(dx)*dxlim;
          otherwise, xlim = x1 + xrange*v/1000 + dxlim*[-.5 .5];
        end;
        if     xlim(1)<x1  xlim = [x1 x1+dxlim] - dxlim/50;
        elseif xlim(2)>x2  xlim = [x2-dxlim x2] + dxlim/50;
        end;
        xlc = mean(xlim);
        v = 1000*(xlc-x1)/xrange;
        v = max(min(v,1000),0);
        [dmy ix] = min(abs(xlc-x));
      end;
      set(gcbo,'val',v,'userdata',v);
      y = y(ix);  yd = 1.01 * (y-ylim);
      if yd(1)<0 ylim = ylim + yd(1); elseif yd(2)>0 ylim = ylim+yd(2); end;
      if sum(xylim - [xlim ylim])
         set(ax,'xlim',xlim,'ylim',ylim);
         if length(ax2) set(ax2,'xlim',xlim); end;
         plt('grid',ax);
         AXeval(Hc(5));
      end;
      cur(CurID,'update',ix);
    case 740
      if ischar(In1) In1 = sscanf(In1,'%d'); end;
      switch In1
        case 2, In1=0; setappdata(cFG,'peak',-inf);
        case 3, In1=1; setappdata(cFG,'vall',inf);
      end;
      y = get(lk,'y'); x = get(lk,'x');
      xx = find(x <= xylim(2) & x >= xylim(1));
      if isempty(xx) x = xylim(1); xx = 1:length(x); disp('You must select a line for the min/max finder'); end;
      y = y(xx);  ly = length(y);
      if In1
         ix=find(y < [y(2:ly) inf] & ...
                 y < [inf  y(1:ly-1)] & ...
                 y > getappdata(cFG,'vall'));
         if isempty(ix)
              [y ix] = min(y);
         else [y i]  = min(y(ix));
              ix = ix(i);
         end;
         setappdata(cFG,'vall',y);
      else
         ix=find(y > [y(2:ly) -inf] & ...
                 y > [-inf y(1:ly-1)] & ...
                 y < getappdata(cFG,'peak'));
         if isempty(ix)
              [y ix] = max(y);
         else [y i] = max(y(ix));
              ix = ix(i);
         end;
         setappdata(cFG,'peak',y);
      end;
      ix = ix + xx(1) - 1;
      cur(CurID,'update',ix);
%
    case 772
      fmt = get(Hc(3),'userdata');
      set(hiy,'str',Pftoa(fmt(2,:),misc(3)));
      set(hix,'str',Pftoa(fmt(1,:),misc(2)));
      set(Hc(12),'vis','of');
      if ~isVIS(Hc(13)) set(Hc([5 7]),'vis','of','str','');  end;
      set(hact,'y',max(xyli(3),min(xyli(4),misc(3))),...
               'x',max(xyli(1),min(xyli(2),misc(2))));
      set(Hc([2:3]),'ena','inact');  set2(Hc(11),'ena','on');
%
    case 529
        l = getappdata(ax,'Lhandles');
%
        for k = 1:length(l)
          L = l(k);  mrk = get(L,'marker');       sty = get(L,'linest');
                     Amrk = getappdata(L,'mrk');  Asty = getappdata(L,'sty');
          if isempty(Amrk)
             if mrk(1)=='n' Amrk = 'o';  else Amrk = mrk; end;  setappdata(L,'mrk',Amrk);
             if sty(1)=='n' Asty = '-';  else Asty = sty; end;  setappdata(L,'sty',Asty);
          end;
          if     sty(1)=='n'  sty = Asty;
          elseif mrk(1)=='n'  sty = 'none';  mrk = Amrk;
          else                mrk = 'none';
          end;
          set(L,'marker',mrk,'linest',sty);
        end;
%
    case 675
      h = Hc(10);  s = get(h,'fontsi');
      s = 14-s;  set(h,'fontsi',s);
      if s==8  setappdata(ax,'Lens',[]);
      else     setappdata(ax,'Lens',{@cur CurID 'lens'});
               bx = Hc(12);
               if isVIS(bx)  xy = [get(bx,'x') get(bx,'y')];  if length(xy)<8 return; end;
                             cur(get(ax,'user'),'lens',[sort(xy(1:2)) sort(xy([6 8]))]);
               end;
      end;
%
    case 434
       fN = 'Lens'; g = cFG;  a = gca;  ar = [];  right = [];  pltt = 0;
       if strcmp(get(g,'name'),fN) fN = 'Lens2'; end;
       f = findobj('type','fig','tag',get(gcf,'tag'),'name',fN);  tg = get(g,'tag');
       while length(f)
          arl = getappdata(f(1),'lens');
          if arl(1) == a  f = f(1);  break;  else f(1) = []; end;
       end;
       if isempty(f)
         h = getappdata(a,'Lhandles');
         tid = cur(0,'TraceIDs');
         for k = 1:length(h)
           aR = get(h(k),'par');  if strcmp(get(h(k),'tag'),'pltt') pltt = k; end;
           if aR ~= a  ar = aR;  right = [right k];  continue; end;
         end;
         pch = findobj(getappdata(g,'pch'),'vis','on');  np = length(pch);
         if np  kk = [];  for k=1:np  u = get(pch(k),'userdata');  kk = [kk u{1}]; end;
                h(kk) = [];  if length(tid) tid(kk) = []; end;
         end;
         arl = [a ar];  ac = get(arl(end),'color');
         vis = get(h,'vis');  ct = get(h,'color');  xy = get(h,'x');  y = get(h,'y');
         if iscell(y) xy = [xy y]'; else xy = {xy y}; end;
         p = get(cFG,'pos');
         p = p + [p(3)+18 0 0 0];  p(3) = 445i;
         th = min(length(h)*16/p(4),.75);
         if length(right) w = .7; ly = {'' ''};  else w = .75; ly = ''; end;
         plt(xy{:},'TraceID',tid,'LabelX','','LabelY',ly,'ENApre',0,'PltBKc',ac,'right',right,...
           'DIStrace',strcmp(get(h,'vis'),'off'),'FigName',fN,'Pos',p,'Options','T','link',g,...
           'TRACEc',ct,'xy',[0 .223 .097 w .87; -1 .004 .99-th .135 th],...
           'LineWidth',get(h,'LineWidth'),'LineStyle',get(h,'LineStyle'),'Marker',get(h,'Marker'));
         f = gcf;  set(f,'tag',tg);  setappdata(f,'lens',arl);
         im = findobj(a,'type','image');
         if length(im)==1
           cb = findobj(g,'tag','cbar');  opt = sprintf('cbar%d',get(cb(1),'userdata'));
           plt('image',1,get(im,'x'),get(im,'y'),get(im,'cdata'),{opt});
         end;
       end;
       aRL = getappdata(f,'axis');  ax = aRL(1);
       cur(get(ax,'user'),'xylim',In1);
       if length(arl)>1 ax2 = aRL(2);  yr = get(arl(2),'ylim');  yl = get(arl(1),'ylim');
                        set(ax2,'ylim',yr(1) + diff(yr) * (In1(3:4)-yl(1)) / diff(yl));
       end;
       figure(g);
%
    case 624
      bu = Hc(11);  c = get(bu,{'backg' 'foreg'});
      if ~isVIS(Hc(13))
            set(bu,'backg',(c{1}+c{2})/2);
            setappdata(ax,'DualCsv',DualCur);
            setappdata(ax,'DualCur',0);
            set(Hc(13),'vis','on','par',get(hact,'par'),'userdata',actv,...
                'x',get(hact,'x'),'y',get(hact,'y'));
      else  set(bu,'backg',c{1}*2 - c{2});
            set(Hc([13 5 7]),'vis','of');
%
%
            set(lk,'vis','of'); drawnow; set(lk,'vis','on');
            DualCur = getappdata(ax,'DualCsv');
            if DualCur setappdata(ax,'DualCur',DualCur); end;
      end;
%
    case 557
      fg = get(hix,'par');
      a = cur(CurID,'TraceIDs');
      if length(a)<actv  d = get(get(ax,'ylab'),'str');
      else               d = a{actv};
      end;
      b = findobj(fg,'buttond','plt click RMS;')';
      if length(b)>1 for k=b if get(k,'userdata')==ax b=k; break; end; end; end;
      set(b,{'str','color'},{d,get(hact,'color')});
      fdc = getappdata(fg,'datacur');
      if length(fdc) & ishandle(fdc)
        s = get(fdc,'userdata');  if length(s) ~= 9 | ~iscell(s) return; end;
        lc = s{1}; xy = s{2};  e = s{3};  AX = s{4};  ll = s{9};  [nr nc] = size(e);
        if length(find(ax==AX))
          i = getappdata(fdc,'cdw');
          if length(i) setappdata(fdc,'cdw',[]);
                       ix = round(min(ll,max(1,i)));  cur(s{6},'update',ix);
          else         ix = max(1,ix);
          end;
          bg = get(e(1,1),'backg');  set(e(1,:),'backg',bg);  bg = .4*bg + .3;  kx = 2;
          for k = 3:nc
            if ~xy(k) kx = k;
            elseif    lc(k)==lk  set([e(1,k) e(1,kx)],'backg',bg); break;
            end;
          end;
          ll = ix + nr - 2 - ll;
          if ll>0 i = max(1,ix-ll); else i = ix; end;  ir = 2 + ix - i;
          for k = 1:nc
            if k>1  if xy(k) yx = 'y'; else yx = 'x'; end;  d = get(lc(k),yx);  n = length(d);
            end;
            for r = 2:nr  v = i + r - 2;  en = 1;
                          if k==1  if r==ir  v = -v; end;
                          else     if v>n en = -1; else v = d(v); end;
                          end;
                          plt('edit',e(r,k),'enable',en,'val',v);
            end;
          end;
        end;
      end;
%
    case 315
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
      tid = 0;  t = findobj(cFG,'user','TraceID');
      for k=1:length(t) if getappdata(t(k),'cid') == CurID  tid = t(k); break; end; end;
      Ret1 = [Hc(2:15) hact tid];
    case 320
%
%
      lineNum = actv;  zdat = 0;
      if Narg2==3 if isnumeric(In1) lineNum = In1; else zdat = 1; end; end;
      k = Hc(15+lineNum);
      if zdat Ret1 = get(lk,'z');  if ix > length(Ret1) Ret1 = NaN; else Ret1 = Ret1(ix); end;
      else    Ret1 = complex(get(k,'x'),get(k,'y'));
      end;
      Ret2 = ix;
    case 956
      Ret1 = actv;
      Ret2 = lk;
      if Narg>2 & ~isVIS(Ret2)
        Ret1 = 0;
      end;  
    case 657
%
%
%
%
%
%
%
%
%
      expHis = get(hiy,'userdata');
      if isempty(expHis)
         Ret1  = [[xylim 1]; [zeros(3,4), -ones(3,1)]];
      else aa = 4 - length(expHis(:,1));
           Ret1 = [ expHis; [ zeros(aa,4), -ones(aa,1) ] ];
      end;
      if length(ax2) Ret1 = [Ret1; [get(ax2,'xlim') get(ax2,'ylim') 2]];
      else           Ret1 = [Ret1; [zeros(1,4) -1]];
      end;
    case 653
       h = Hc([2:11 15+1:end])';
       h = [h(ishandle(h)); findobj(cFG,'tag','xslider')];
       for k = findobj(cFG,'buttond','plt click RMS;')' if get(k,'userdata') == gca  h = [h; k]; end; end;
       for k = [getappdata(gca,'xstr') getappdata(gca,'ystr') getappdata(gca,'ystr')] h = [h; k]; end;
       h = findobj(h,'vis','on');
       set(h,'vis','of');
       setappdata(Hc(2),'hid',h);
    case 559, h = Hc(2);
                 set(getappdata(h,'hid'),'vis','on');
                 rmappdata(h,'hid');
    case 985
%
%
%
%
%
%
%
%
%
%
       for i=2:11 if ishandle(Hc(i)) set(Hc(i),'pos',In1(i-1,:)); end; end;
    case 423,     set(Hc(2),'str',In1);
    case 424,     set(Hc(3),'str',In1);
    case 636,   if length(In1) & ischar(In1) & In1(1)==';'
                       setappdata(ax,'moveCBext',1);  In1(1) = [];
                    end;
                    set(Hc(7),'userdata',In1);
    case 686,  setappdata(Hc(7),'CB2',In1);
    case 684,  setappdata(Hc(5),'CB2',In1);
    case {563,443,442},
      if isempty(In1) return; end;
      oldEh = get(hiy,'userdata');
      expHis = oldEh;
      if length(expHis)
          curExp = find(expHis(:,5)==1);
          if length(curExp) expHis(curExp,5)=0; end;
      end;
%
      switch sact
        case 563, xyl = In1;  expHis(1,:) = [xyl 1];
        case 443
           if length(oldEh)  expHis(1,:) = [xylim(1:2) In1,1];  xyl = [xylim(1:2) In1];
           else              expHis=[];                         xyl = [xylim(1:2) In1];
           end;
        case 442
           if length(oldEh)  expHis(1,:) = [In1 xylim(3:4) 1]; xyl = [In1 xylim(3:4)];
           else              expHis=[];                        xyl = [In1 xylim(3:4)];
           end
      end;
%
%
%
      xyll = sort(xyl(1:2));  if diff(xyll) set(ax,'xlim',xyll); end;
      xyll = sort(xyl(3:4));  if diff(xyll) set(ax,'ylim',xyll); end;
      set(hiy,'userdata',expHis);
      if length(ax2)
         if Narg2==5 xy = In3; else  xy = get(ax2,'ylim'); end;
         set(ax2,'xlim',xyl(1:2),'ylim',xy);
         set(hix,'userdata',misc);
      end;
      plt('grid',ax);
      if Action(end-2)=='l'  AXeval(Hc(5));  end;
      xView = getappdata(ax,'xView');
      if length(xView) set(xView{1},'x',get(ax,'xlim')); end;
    case 540,
      setappdata(cFG,'peak',-inf); setappdata(cFG,'vall',inf);
    case 993,
%
      if length(In1(1,:)) < 5
%
%
         cur(CurID,'xyLim',In2);
      elseif isequal(size(In1),[5 5])
        expHis = [];
        for i=1:5
          if i<=4
            if In1(i,5) >= 0
              expHis=[expHis; In1(i,:)];
              if In1(i,5) == 1
                 xylim = In1(i,1:4);
                 set(ax,'xlim',In1(i,1:2),'ylim',In1(i,3:4));
                 plt('grid',ax);
              end;
            end
          else
            if In1(i,5)==2 set(ax2,'xlim',In1(i,1:2),'ylim',In1(i,3:4)); end;
          end;
        end;
        set(hiy,'userdata',expHis);
      else disp('error in plt(cursor,CurId,set,exRestore,xxx), xxx is wrong shape');
      end;
    case 968
      if In1
        misc(4) = In1;
        set(hix,'userdata',misc);
      end;
      upd = 'update';
      if isempty(In2) In2 = -1;
      else            if In2<0 upd = 'updateN'; In2 = -In2; end;
      end;
      cur(CurID,upd,In2);
%
    case 519
      hcl = Hc([2:13 15+1:end]);
      delete(hcl(find(ishandle(hcl))));
      CurMain(CurID) = 0;
      if ~sum(CurMain) CurMain = []; end;
      setappdata(0,'CurMain',CurMain);
%
    case 957
      ofs = strcmp(In1,'y');
      switch sum(get(gcf,'SelectionT'))
      case 649,
         if misc(7+ofs)
            cur(CurID,'scale','new');  misc(7)=0;  misc(8)=0;  set(hix,'userdata',misc);
         else
            fmty = get(Hc(3),'userdata');  fmtx = fmty(1,:);  fmty = fmty(2,:);
            c = {'backg' 'foreg'};  clr = get(hix,c);
            set(Hc(4), 'str',Pftoa(fmtx,xylim(1)),'ena','on');
            set(Hc(5),'str',Pftoa(fmtx,xylim(2)),'ena','on',c,clr,'vis','on');
            set(Hc(6), 'str',Pftoa(fmty,xylim(3)),'ena','on');
            set(Hc(7),'str',Pftoa(fmty,xylim(4)),'ena','on',c,clr,'vis','on');
            misc(7+ofs)=1;
            if ~misc(7) | ~misc(8)
               set(Hc(12),'x',xylim([1 2 2 1 1]),'y',xylim([3 3 4 4 3]),'vis','on');
               cur(CurID,'ZoomOut',0.2);
            end;
            set(hix,'userdata',misc);
         end;
      case 321, cur(CurID,'scale','auto',In1);
      end;
%
    case 797
%
      if Narg<3  d = [-.2 .2]; e = [.5 2];
      else       d = In1/2; e = 10^d;  d = [-d d];  e = [1/e e];
      end;
      xl = xylim(1:2);   yl = xylim(3:4);   dr = 'o';
      clk = sum(get(gcf,'SelectionT'));
      if clk==321 | (clk==434 & getappdata(ax,'dir')=='i')
        d = d(2); d = d/(1+2*d); d = [d -d]; e = 1./e; dr = 'i';
      end;
      xs = get(ax,'Xscale');  ys = get(ax,'Yscale');
      if xs(2)=='i' xl = xl + diff(xl)*d;
      else          xl = e.*xl;  if diff(xl)<=0 xl = xl./e; end;
      end;
      if ys(2)=='i' yl = yl + diff(yl)*d;
      else          yl = e.*yl;  if diff(yl)<=0 yl = yl./e; end;
      end;
      set(ax,'xlim',xl,'ylim',yl);
      if ishandle(ax2)
        set(ax2,'xlim',xl);
        axl = get(get(ax2,'ylab'),'str');
        if axl(1)~=92 | axl(2) ~= 'd';
          yl = get(ax2,'ylim');
          if ys(2)=='i' yl = yl + diff(yl)*d;
          else          yl = e.*yl;  if diff(yl)<=0 yl = yl./e; end;
          end;
          set(ax2,'ylim',yl);
        end;
      end;
      plt('grid',ax);
      setappdata(ax,'dir',dr);
      axes(ax); AXeval(Hc(5));
      xView = getappdata(ax,'xView');
      if length(xView) set(xView{1},'x',get(ax,'xlim')); end;
%
    case 427
      if sum(get(gcf,'SelectionT'))==321 plt('xright','mark','0'); return; end;
      axes(ax);  x = get(hact,'x'); y = get(hact,'y');  p = get(hact,'par');
      if p ~= ax
        rlim = xyli(3:4);
        ylim = xylim(3:4);
        y = ylim(1) + diff(ylim) * (y - rlim(1)) / diff(rlim);
      end;
      l = line(x,y,'marker','s');
      t = text(x,y,['   (' get(hix,'str') ', ' get(hiy,'str') ')'],'units','data',...
               'fontsi',get(p,'fontsi'),'userdata',l,'buttond','plt misc marker;');
%
      set([t l],'color',get(hact,'color'),'tag','mark');
      if p ~= ax set(l,'tag','markR','userdata',{t ax p ylim rlim}); end;
%
    case 770
      if sum(get(gcf,'SelectionT'))==321 plt('hcpy','init',cFG);
      else
        hl = [findobj(cFG,'str','LinY'); findobj(cFG,'str','LogY')]';
        for j=hl  b = get(j,'buttond');
                  if iscell(b) & length(b)>2 & b{3}==CurID break; end;
        end;
        if strcmp(get(ax,'Yscale'),'log')
             sc='linear'; st='LinY';
        else sc='log';    st='LogY';
             if xylim(3)<=0 set(ax,'ylim',abs(xylim(4))*[.001 1]); end;
             if ishandle(ax2)
               y = get(ax2,'ylim'); if y(1)<=0 set(ax2,'ylim',abs(y(2))*[.001 1]); end;
               end;
        end;
        set(axrl,'Yscale',sc);  set(j,'str',st);
      end;
%
    case 769
      if sum(get(gcf,'SelectionT'))==321
        h = getappdata(ax,'Lhandles');
        x = get(h,'x'); y = get(h,'y');
        if length(h)>1 set(h,{'x'},y,{'y'},x);
        else           set(h,'x',y,'y',x);
        end;
        a = ax;
        for k = 1:2
          if k>1 a=ax2; if ~ishandle(a) continue; end; end;          
          set(a,'xlim',get(a,'ylim'),'ylim',get(a,'xlim'));
          x = get(a,'xlab');  y = get(a,'ylab');
          sx = get(x,'str'); set(x,'str',get(y,'str')); set(y,'str',sx);
        end;
        plt('grid',ax);  cur(get(ax,'userdata'));
      else
        hl = [findobj(cFG,'str','LinX'); findobj(cFG,'str','LogX')]';
        for j=hl  b = get(j,'buttond');
                  if iscell(b) & length(b)>2 & b{3}==CurID break; end;
        end;
        p = get(ax,'pos');  p = p(1);
        if getappdata(cFG,'indep') < 0
          a = getappdata(cFG,'axis');
          axe = [];
          for k = a
            q = get(k,'pos');
            if p == q(1) axe = [axe k]; end;
          end;
        else axe = axrl;
        end;
        if strcmp(get(ax,'Xscale'),'log')
             sc='linear'; st='LinX';
        else sc='log';    st='LogX';
             if xylim(1)<=0 set(axe,'xlim',abs(xylim(2))*[.001 1]); end;
        end;
        set(axe,'Xscale',sc); set(j,'str',st);
        if isempty(ax2) ax2 = 0; end;
        for k = axe if k ~= ax2 plt('grid',k); end; end;
      end;
%
    case 847
       Ret1 = getappdata(Hc(2),'TraceIDs');
%
    case 522
      pr = {'str' 'fontn'};  h = Hc(3);  s = 0;  of = getappdata(h,'of');
      switch lower(In1(1))
         case 'o',  if length(of) set(h,pr,of); rmappdata(h,'of'); end;
         case 'u',  s = 68;
         case 'l',  s = 62;
         case 'b',  s = 168;
      end;
      if s if isempty(of) setappdata(h,'of',get(h,pr)); end;
           set(h,pr,{char(s) 'symbol'});
      end;

%
    otherwise disp([Action ' is not a valid action in plt(cursor)']);
    end;
%

function set2(h,varargin)
  set(h(ishandle(h)),varargin{:});

function c = divc(a,b)
  c = complex(real(a)/real(b),imag(a)/imag(b));

function v = isVIS(h)
   v = strcmp(get(h,'vis'),'on');

function AXeval(a)
  cb1 = get(a,'userdata');          if length(cb1) evalQ(cb1); end;
  cb2 = getappdata(a,'CB2');  if length(cb2) evalQ(cb2); end;

function setlim(ax,prop,lim);
  if lim(1) <= 0 | lim(2) <= 0
    s = get(ax,[prop(1) 'scale']);
    if s(2) == 'o' lim = abs(lim(2))*[0.001 1]; end;
  end;
  set(ax,prop,lim);

function evalRep(a,rep)
  if ischar(a)     for k=1:2:length(rep) a = strrep(a,rep{k},rep{k+1}); end;
                   a = strrep(a,'"','''');
                   eval(a);
  elseif iscell(a) feval(a{:});
  else             feval(a);
  end;

function r = evalRep2(a,rep)
  if ischar(a)     for k=1:2:length(rep) a = strrep(a,rep{k},rep{k+1}); end;
                   a = strrep(a,'"','''');
                   r = eval(a);
  elseif iscell(a) r = feval(a{:});
  else             r = feval(a);
  end;

function evalQ(a)
  if ischar(a)     a = strrep(a,'"','''');
                   eval(a);
  elseif iscell(a) feval(a{:});
  else             feval(a);
  end;

function r2 = cur2nd(v)
  [r1 r2] = cur(v{:});

function fixMark()
  markR = findobj(gcf,'tag','markR')';
  if isempty(markR) return; end;
  for l = markR
    u = get(l,'userdata');
    t = u{1};  ax = u{2};  axr = u{3};  ylim = u{4};  rlim = u{5};
    if ishandle(t) p = get(t,'pos');  else p = [0 0]; end;
    y = [get(l,'y') p(2)];
    y = rlim(1) + diff(rlim) * (y - ylim(1)) / diff(ylim);
    rlim = get(axr,'ylim');   ylim = get(ax,'ylim');
    y = ylim(1) + diff(ylim) * (y - rlim(1)) / diff(rlim);
    set(l,'y',y(1),'userdata',[u(1:3) {ylim rlim}]);
    if ishandle(t) p(2) = y(2);  set(t,'pos',p); end;
  end;
%

function rep1 = updateS(ax,CurID)
  s = [getappdata(ax,'xstr') getappdata(ax,'ystr') getappdata(ax,'zstr')];
  rep1 = {'@XVAL','real(@XY)',...
          '@YVAL','imag(@XY)',...
          '@XY',  'cur(@CID,"get")',...
          '@ZVAL','cur(@CID,"get","z")',...
          '@IDX', 'cur2nd({@CID,"get"})',...
          '@LNUM','cur(@CID,"getActive")',...
          '@HAND','cur2nd({@CID,"getActive"})',...
          '@Q1',  'plt("misc",21)',...
          '@Q2',  'plt("misc",22)',...
          '@Q3',  'plt("misc",23)',...
          '@Q4',  'plt("misc",24)',...
          '@V1(', 'plt("misc",11,',...
          '@V2(', 'plt("misc",12,',...
          '@V3(', 'plt("misc",13,',...
          '@V4(', 'plt("misc",14,',...
          '@CID', sprintf('%d',CurID)};
  for k=1:length(s)  set(s(k),'str',evalRep2(getappdata(s(k),'evl'),rep1));  end;

function [rpt,p] = getREPEAT(e)
  rpt = getappdata(gcbo,'repeat');
  if nargin & isempty(rpt)
     b = get(gcbo,'buttond');
     if iscell(b) & length(b)>2 rpt = getappdata(b{3},'repeat'); end;
  end;
  if length(rpt)>1 p = rpt(2);
  else       p = .5;  if exist('p') p = .4; end;
  end;  
  if length(rpt) rpt = rpt(1);
  else           rpt = .03;
  end;

function mZoom(xy)
  s = {'Lens' 'MotionZoom'};
  for k = 1:2
    a = getappdata(gca,s{k});
    if length(a)
      x = sort(xy(1:2));  y = sort(xy(3:4));
      if diff(x) & diff(y)
        b = [x y];
        if ischar(a)     feval(a,b);
        elseif iscell(a) a = [a {b}]; feval(a{:});
        else             a = {a b};   feval(a{:});
        end;
      end;
      return;
    end;
  end;
